/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.example.invoice;

import io.orqueio.bpm.engine.AuthorizationService;
import io.orqueio.bpm.engine.FilterService;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.TaskService;
import io.orqueio.bpm.engine.authorization.Authorization;
import io.orqueio.bpm.engine.authorization.Permission;
import io.orqueio.bpm.engine.authorization.Permissions;
import io.orqueio.bpm.engine.authorization.Resource;
import io.orqueio.bpm.engine.authorization.Resources;
import io.orqueio.bpm.engine.filter.Filter;
import io.orqueio.bpm.engine.identity.Group;
import io.orqueio.bpm.engine.identity.User;
import io.orqueio.bpm.engine.impl.IdentityServiceImpl;
import io.orqueio.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import io.orqueio.bpm.engine.query.Query;
import io.orqueio.bpm.engine.task.TaskQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class DemoDataGenerator {
    private static final Logger LOGGER = Logger.getLogger(DemoDataGenerator.class.getName());

    public void createUsers(ProcessEngine engine) {
        IdentityServiceImpl identityService = (IdentityServiceImpl)engine.getIdentityService();
        if (identityService.isReadOnly()) {
            LOGGER.info("Identity service provider is Read Only, not creating any demo users.");
            return;
        }
        User singleResult = (User)identityService.createUserQuery().userId("demo").singleResult();
        if (singleResult != null) {
            return;
        }
        LOGGER.info("Generating demo data for invoice showcase");
        User user = identityService.newUser("demo");
        user.setFirstName("Demo");
        user.setLastName("Demo");
        user.setPassword("demo");
        user.setEmail("demo@orqueio.io");
        identityService.saveUser(user, true);
        User user2 = identityService.newUser("john");
        user2.setFirstName("John");
        user2.setLastName("Doe");
        user2.setPassword("john");
        user2.setEmail("john@orqueio.io");
        identityService.saveUser(user2, true);
        User user3 = identityService.newUser("mary");
        user3.setFirstName("Mary");
        user3.setLastName("Anne");
        user3.setPassword("mary");
        user3.setEmail("mary@orqueio.io");
        identityService.saveUser(user3, true);
        User user4 = identityService.newUser("peter");
        user4.setFirstName("Peter");
        user4.setLastName("Meter");
        user4.setPassword("peter");
        user4.setEmail("peter@orqueio.io");
        identityService.saveUser(user4, true);
        Group salesGroup = identityService.newGroup("sales");
        salesGroup.setName("Sales");
        salesGroup.setType("WORKFLOW");
        identityService.saveGroup(salesGroup);
        Group accountingGroup = identityService.newGroup("accounting");
        accountingGroup.setName("Accounting");
        accountingGroup.setType("WORKFLOW");
        identityService.saveGroup(accountingGroup);
        Group managementGroup = identityService.newGroup("management");
        managementGroup.setName("Management");
        managementGroup.setType("WORKFLOW");
        identityService.saveGroup(managementGroup);
        AuthorizationService authorizationService = engine.getAuthorizationService();
        if (identityService.createGroupQuery().groupId("orqueio-admin").count() == 0L) {
            Group orqueioAdminGroup = identityService.newGroup("orqueio-admin");
            orqueioAdminGroup.setName("OrqueIO BPM Administrators");
            orqueioAdminGroup.setType("SYSTEM");
            identityService.saveGroup(orqueioAdminGroup);
        }
        for (Group resource : Resources.values()) {
            if (authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"orqueio-admin"}).resourceType((Resource)resource).resourceId("*").count() != 0L) continue;
            AuthorizationEntity userAdminAuth = new AuthorizationEntity(1);
            userAdminAuth.setGroupId("orqueio-admin");
            userAdminAuth.setResource((Resource)resource);
            userAdminAuth.setResourceId("*");
            userAdminAuth.addPermission((Permission)Permissions.ALL);
            authorizationService.saveAuthorization((Authorization)userAdminAuth);
        }
        identityService.createMembership("demo", "sales");
        identityService.createMembership("demo", "accounting");
        identityService.createMembership("demo", "management");
        identityService.createMembership("demo", "orqueio-admin");
        identityService.createMembership("john", "sales");
        identityService.createMembership("mary", "accounting");
        identityService.createMembership("peter", "management");
        Authorization salesTasklistAuth = authorizationService.createNewAuthorization(1);
        salesTasklistAuth.setGroupId("sales");
        salesTasklistAuth.addPermission((Permission)Permissions.ACCESS);
        salesTasklistAuth.setResourceId("tasklist");
        salesTasklistAuth.setResource((Resource)Resources.APPLICATION);
        authorizationService.saveAuthorization(salesTasklistAuth);
        Authorization salesReadProcessDefinition = authorizationService.createNewAuthorization(1);
        salesReadProcessDefinition.setGroupId("sales");
        salesReadProcessDefinition.addPermission((Permission)Permissions.READ);
        salesReadProcessDefinition.addPermission((Permission)Permissions.READ_HISTORY);
        salesReadProcessDefinition.setResource((Resource)Resources.PROCESS_DEFINITION);
        salesReadProcessDefinition.setResourceId("invoice");
        authorizationService.saveAuthorization(salesReadProcessDefinition);
        Authorization accountingTasklistAuth = authorizationService.createNewAuthorization(1);
        accountingTasklistAuth.setGroupId("accounting");
        accountingTasklistAuth.addPermission((Permission)Permissions.ACCESS);
        accountingTasklistAuth.setResourceId("tasklist");
        accountingTasklistAuth.setResource((Resource)Resources.APPLICATION);
        authorizationService.saveAuthorization(accountingTasklistAuth);
        Authorization accountingReadProcessDefinition = authorizationService.createNewAuthorization(1);
        accountingReadProcessDefinition.setGroupId("accounting");
        accountingReadProcessDefinition.addPermission((Permission)Permissions.READ);
        accountingReadProcessDefinition.addPermission((Permission)Permissions.READ_HISTORY);
        accountingReadProcessDefinition.setResource((Resource)Resources.PROCESS_DEFINITION);
        accountingReadProcessDefinition.setResourceId("invoice");
        authorizationService.saveAuthorization(accountingReadProcessDefinition);
        Authorization managementTasklistAuth = authorizationService.createNewAuthorization(1);
        managementTasklistAuth.setGroupId("management");
        managementTasklistAuth.addPermission((Permission)Permissions.ACCESS);
        managementTasklistAuth.setResourceId("tasklist");
        managementTasklistAuth.setResource((Resource)Resources.APPLICATION);
        authorizationService.saveAuthorization(managementTasklistAuth);
        Authorization managementReadProcessDefinition = authorizationService.createNewAuthorization(1);
        managementReadProcessDefinition.setGroupId("management");
        managementReadProcessDefinition.addPermission((Permission)Permissions.READ);
        managementReadProcessDefinition.addPermission((Permission)Permissions.READ_HISTORY);
        managementReadProcessDefinition.setResource((Resource)Resources.PROCESS_DEFINITION);
        managementReadProcessDefinition.setResourceId("invoice");
        authorizationService.saveAuthorization(managementReadProcessDefinition);
        Authorization salesDemoAuth = authorizationService.createNewAuthorization(1);
        salesDemoAuth.setGroupId("sales");
        salesDemoAuth.setResource((Resource)Resources.USER);
        salesDemoAuth.setResourceId("demo");
        salesDemoAuth.addPermission((Permission)Permissions.READ);
        authorizationService.saveAuthorization(salesDemoAuth);
        Authorization salesJohnAuth = authorizationService.createNewAuthorization(1);
        salesJohnAuth.setGroupId("sales");
        salesJohnAuth.setResource((Resource)Resources.USER);
        salesJohnAuth.setResourceId("john");
        salesJohnAuth.addPermission((Permission)Permissions.READ);
        authorizationService.saveAuthorization(salesJohnAuth);
        Authorization manDemoAuth = authorizationService.createNewAuthorization(1);
        manDemoAuth.setGroupId("management");
        manDemoAuth.setResource((Resource)Resources.USER);
        manDemoAuth.setResourceId("demo");
        manDemoAuth.addPermission((Permission)Permissions.READ);
        authorizationService.saveAuthorization(manDemoAuth);
        Authorization manPeterAuth = authorizationService.createNewAuthorization(1);
        manPeterAuth.setGroupId("management");
        manPeterAuth.setResource((Resource)Resources.USER);
        manPeterAuth.setResourceId("peter");
        manPeterAuth.addPermission((Permission)Permissions.READ);
        authorizationService.saveAuthorization(manPeterAuth);
        Authorization accDemoAuth = authorizationService.createNewAuthorization(1);
        accDemoAuth.setGroupId("accounting");
        accDemoAuth.setResource((Resource)Resources.USER);
        accDemoAuth.setResourceId("demo");
        accDemoAuth.addPermission((Permission)Permissions.READ);
        authorizationService.saveAuthorization(accDemoAuth);
        Authorization accMaryAuth = authorizationService.createNewAuthorization(1);
        accMaryAuth.setGroupId("accounting");
        accMaryAuth.setResource((Resource)Resources.USER);
        accMaryAuth.setResourceId("mary");
        accMaryAuth.addPermission((Permission)Permissions.READ);
        authorizationService.saveAuthorization(accMaryAuth);
        Authorization taskMaryAuth = authorizationService.createNewAuthorization(1);
        taskMaryAuth.setUserId("mary");
        taskMaryAuth.setResource((Resource)Resources.TASK);
        taskMaryAuth.setResourceId("*");
        taskMaryAuth.addPermission((Permission)Permissions.READ);
        taskMaryAuth.addPermission((Permission)Permissions.UPDATE);
        authorizationService.saveAuthorization(taskMaryAuth);
        FilterService filterService = engine.getFilterService();
        HashMap<String, Object> filterProperties = new HashMap<String, Object>();
        filterProperties.put("description", "Tasks assigned to me");
        filterProperties.put("priority", -10);
        this.addVariables(filterProperties);
        TaskService taskService = engine.getTaskService();
        TaskQuery query = taskService.createTaskQuery().taskAssigneeExpression("${currentUser()}");
        Filter myTasksFilter = filterService.newTaskFilter().setName("My Tasks").setProperties(filterProperties).setOwner("demo").setQuery((Query)query);
        filterService.saveFilter(myTasksFilter);
        filterProperties.clear();
        filterProperties.put("description", "Tasks assigned to my Groups");
        filterProperties.put("priority", -5);
        this.addVariables(filterProperties);
        query = taskService.createTaskQuery().taskCandidateGroupInExpression("${currentUserGroups()}").taskUnassigned();
        Filter groupTasksFilter = filterService.newTaskFilter().setName("My Group Tasks").setProperties(filterProperties).setOwner("demo").setQuery((Query)query);
        filterService.saveFilter(groupTasksFilter);
        Authorization globalMyTaskFilterRead = authorizationService.createNewAuthorization(0);
        globalMyTaskFilterRead.setResource((Resource)Resources.FILTER);
        globalMyTaskFilterRead.setResourceId(myTasksFilter.getId());
        globalMyTaskFilterRead.addPermission((Permission)Permissions.READ);
        authorizationService.saveAuthorization(globalMyTaskFilterRead);
        Authorization globalGroupFilterRead = authorizationService.createNewAuthorization(0);
        globalGroupFilterRead.setResource((Resource)Resources.FILTER);
        globalGroupFilterRead.setResourceId(groupTasksFilter.getId());
        globalGroupFilterRead.addPermission((Permission)Permissions.READ);
        authorizationService.saveAuthorization(globalGroupFilterRead);
        filterProperties.clear();
        filterProperties.put("description", "Tasks for Group Accounting");
        filterProperties.put("priority", -3);
        this.addVariables(filterProperties);
        query = taskService.createTaskQuery().taskCandidateGroupIn(Arrays.asList("accounting")).taskUnassigned();
        Filter candidateGroupTasksFilter = filterService.newTaskFilter().setName("Accounting").setProperties(filterProperties).setOwner("demo").setQuery((Query)query);
        filterService.saveFilter(candidateGroupTasksFilter);
        Authorization managementGroupFilterRead = authorizationService.createNewAuthorization(1);
        managementGroupFilterRead.setResource((Resource)Resources.FILTER);
        managementGroupFilterRead.setResourceId(candidateGroupTasksFilter.getId());
        managementGroupFilterRead.addPermission((Permission)Permissions.READ);
        managementGroupFilterRead.setGroupId("accounting");
        authorizationService.saveAuthorization(managementGroupFilterRead);
        filterProperties.clear();
        filterProperties.put("description", "Tasks assigned to John");
        filterProperties.put("priority", -1);
        this.addVariables(filterProperties);
        query = taskService.createTaskQuery().taskAssignee("john");
        Filter johnsTasksFilter = filterService.newTaskFilter().setName("John's Tasks").setProperties(filterProperties).setOwner("demo").setQuery((Query)query);
        filterService.saveFilter(johnsTasksFilter);
        filterProperties.clear();
        filterProperties.put("description", "Tasks assigned to Mary");
        filterProperties.put("priority", -1);
        this.addVariables(filterProperties);
        query = taskService.createTaskQuery().taskAssignee("mary");
        Filter marysTasksFilter = filterService.newTaskFilter().setName("Mary's Tasks").setProperties(filterProperties).setOwner("demo").setQuery((Query)query);
        filterService.saveFilter(marysTasksFilter);
        filterProperties.clear();
        filterProperties.put("description", "Tasks assigned to Peter");
        filterProperties.put("priority", -1);
        this.addVariables(filterProperties);
        query = taskService.createTaskQuery().taskAssignee("peter");
        Filter petersTasksFilter = filterService.newTaskFilter().setName("Peter's Tasks").setProperties(filterProperties).setOwner("demo").setQuery((Query)query);
        filterService.saveFilter(petersTasksFilter);
        filterProperties.clear();
        filterProperties.put("description", "All Tasks - Not recommended to be used in production :)");
        filterProperties.put("priority", 10);
        this.addVariables(filterProperties);
        query = taskService.createTaskQuery();
        Filter allTasksFilter = filterService.newTaskFilter().setName("All Tasks").setProperties(filterProperties).setOwner("demo").setQuery((Query)query);
        filterService.saveFilter(allTasksFilter);
    }

    protected void addVariables(Map<String, Object> filterProperties) {
        ArrayList<Object> variables = new ArrayList<Object>();
        this.addVariable(variables, "amount", "Invoice Amount");
        this.addVariable(variables, "invoiceNumber", "Invoice Number");
        this.addVariable(variables, "creditor", "Creditor");
        this.addVariable(variables, "approver", "Approver");
        filterProperties.put("variables", variables);
    }

    protected void addVariable(List<Object> variables, String name, String label) {
        HashMap<String, String> variable = new HashMap<String, String>();
        variable.put("name", name);
        variable.put("label", label);
        variables.add(variable);
    }
}

