/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.spring.boot.starter.webapp;

import io.orqueio.bpm.spring.boot.starter.OrqueioBpmAutoConfiguration;
import io.orqueio.bpm.spring.boot.starter.property.OrqueioBpmProperties;
import io.orqueio.bpm.spring.boot.starter.property.WebappProperty;
import io.orqueio.bpm.spring.boot.starter.webapp.FaviconResourceResolver;
import io.orqueio.bpm.spring.boot.starter.webapp.OrqueioBpmWebappInitializer;
import io.orqueio.bpm.spring.boot.starter.webapp.filter.LazyDelegateFilter;
import io.orqueio.bpm.spring.boot.starter.webapp.filter.LazyInitRegistration;
import io.orqueio.bpm.spring.boot.starter.webapp.filter.ResourceLoaderDependingFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.resource.ResourceResolver;

@Configuration
@ConditionalOnProperty(prefix="camunda.bpm.webapp", name={"enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={OrqueioBpmProperties.class})
@ConditionalOnWebApplication
@AutoConfigureAfter(value={OrqueioBpmAutoConfiguration.class})
public class OrqueioBpmWebappAutoConfiguration
implements WebMvcConfigurer {
    @Autowired
    private ResourceLoader resourceLoader;
    @Autowired
    private OrqueioBpmProperties properties;

    @Bean
    public OrqueioBpmWebappInitializer orqueioBpmWebappInitializer() {
        return new OrqueioBpmWebappInitializer(this.properties);
    }

    @Bean(name={"resourceLoaderDependingInitHook"})
    public LazyDelegateFilter.InitHook<ResourceLoaderDependingFilter> resourceLoaderDependingInitHook() {
        return filter -> {
            filter.setResourceLoader(this.resourceLoader);
            filter.setWebappProperty(this.properties.getWebapp());
        };
    }

    @Bean
    public LazyInitRegistration lazyInitRegistration() {
        return new LazyInitRegistration();
    }

    @Bean
    public FaviconResourceResolver faviconResourceResolver() {
        return new FaviconResourceResolver();
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        String classpath = "classpath:" + this.properties.getWebapp().getWebjarClasspath();
        WebappProperty webapp = this.properties.getWebapp();
        String applicationPath = webapp.getApplicationPath();
        registry.addResourceHandler(new String[]{applicationPath + "/lib/**"}).addResourceLocations(new String[]{classpath + "/lib/"});
        registry.addResourceHandler(new String[]{applicationPath + "/api/**"}).addResourceLocations(new String[]{"classpath:/api/"});
        registry.addResourceHandler(new String[]{applicationPath + "/app/**"}).addResourceLocations(new String[]{classpath + "/app/"});
        registry.addResourceHandler(new String[]{applicationPath + "/assets/**"}).addResourceLocations(new String[]{classpath + "/assets/"});
        registry.addResourceHandler(new String[]{applicationPath + "/favicon.ico"}).addResourceLocations(new String[]{classpath + "/"}).resourceChain(true).addResolver((ResourceResolver)this.faviconResourceResolver());
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        WebappProperty webapp = this.properties.getWebapp();
        if (webapp.isIndexRedirectEnabled()) {
            String applicationPath = webapp.getApplicationPath();
            registry.addRedirectViewController("/", applicationPath + "/app/");
        }
    }
}

