/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.run;

import io.orqueio.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.orqueio.bpm.engine.impl.cfg.ProcessEnginePlugin;
import io.orqueio.bpm.engine.impl.plugin.AdministratorAuthorizationPlugin;
import io.orqueio.bpm.identity.impl.ldap.plugin.LdapIdentityProviderPlugin;
import io.orqueio.bpm.run.OrqueioBpmRunDeploymentConfiguration;
import io.orqueio.bpm.run.OrqueioBpmRunProcessEngineConfiguration;
import io.orqueio.bpm.run.property.OrqueioBpmRunProperties;
import io.orqueio.bpm.spring.boot.starter.OrqueioBpmAutoConfiguration;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@EnableConfigurationProperties(value={OrqueioBpmRunProperties.class})
@Configuration
@AutoConfigureAfter(value={OrqueioBpmAutoConfiguration.class})
public class OrqueioBpmRunConfiguration {
    @Bean
    @ConditionalOnProperty(name={"enabled"}, havingValue="true", prefix="camunda.bpm.run.ldap")
    public LdapIdentityProviderPlugin ldapIdentityProviderPlugin(OrqueioBpmRunProperties properties) {
        return properties.getLdap();
    }

    @Bean
    @ConditionalOnProperty(name={"enabled"}, havingValue="true", prefix="camunda.bpm.run.admin-auth")
    public AdministratorAuthorizationPlugin administratorAuthorizationPlugin(OrqueioBpmRunProperties properties) {
        return properties.getAdminAuth();
    }

    @Bean
    public ProcessEngineConfigurationImpl processEngineConfigurationImpl(List<ProcessEnginePlugin> processEnginePluginsFromContext, OrqueioBpmRunProperties properties, OrqueioBpmRunDeploymentConfiguration deploymentConfig) {
        String normalizedDeploymentDir = deploymentConfig.getNormalizedDeploymentDir();
        boolean deployChangedOnly = properties.getDeployment().isDeployChangedOnly();
        List processEnginePluginsFromYaml = properties.getProcessEnginePlugins();
        return new OrqueioBpmRunProcessEngineConfiguration(normalizedDeploymentDir, deployChangedOnly, processEnginePluginsFromContext, processEnginePluginsFromYaml);
    }

    @Bean
    public OrqueioBpmRunDeploymentConfiguration orqueioDeploymentConfiguration(@Value(value="${orqueio.deploymentDir:#{null}}") String deploymentDir) {
        return new OrqueioBpmRunDeploymentConfiguration(deploymentDir);
    }
}

