/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.run;

import io.orqueio.bpm.engine.ProcessEngineException;
import io.orqueio.bpm.engine.impl.cfg.CompositeProcessEnginePlugin;
import io.orqueio.bpm.engine.impl.cfg.ProcessEnginePlugin;
import io.orqueio.bpm.engine.spring.SpringProcessEngineConfiguration;
import io.orqueio.bpm.run.property.OrqueioBpmRunProcessEnginePluginProperty;
import io.orqueio.bpm.run.utils.OrqueioBpmRunProcessEnginePluginHelper;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.springframework.core.io.Resource;

public class OrqueioBpmRunProcessEngineConfiguration
extends SpringProcessEngineConfiguration {
    private final String normalizedDeploymentDir;

    public OrqueioBpmRunProcessEngineConfiguration(String normalizedDeploymentDir, boolean deployChangedOnly, List<ProcessEnginePlugin> processEnginePluginsFromContext, List<OrqueioBpmRunProcessEnginePluginProperty> processEnginePluginsFromYaml) {
        this.normalizedDeploymentDir = normalizedDeploymentDir;
        this.setDeployChangedOnly(deployChangedOnly);
        this.configureProcessEnginePlugins(processEnginePluginsFromContext, processEnginePluginsFromYaml);
    }

    protected String getFileResourceName(Resource resource) {
        try {
            String resourceAbsolutePath = resource.getURI().toString();
            int startIndex = resourceAbsolutePath.indexOf(this.normalizedDeploymentDir) + this.normalizedDeploymentDir.length();
            return resourceAbsolutePath.substring(startIndex);
        }
        catch (IOException e) {
            throw new ProcessEngineException("Failed to locate resource " + resource.getFilename(), (Throwable)e);
        }
    }

    protected void initTelemetryData() {
        super.initTelemetryData();
        Set orqueioIntegration = this.telemetryData.getProduct().getInternals().getOrqueioIntegration();
        orqueioIntegration.add("orqueio-bpm-run");
    }

    protected void configureProcessEnginePlugins(List<ProcessEnginePlugin> processEnginePluginsFromContext, List<OrqueioBpmRunProcessEnginePluginProperty> processEnginePluginsFromYaml) {
        OrqueioBpmRunProcessEnginePluginHelper.registerYamlPlugins(processEnginePluginsFromContext, processEnginePluginsFromYaml);
        this.processEnginePlugins.add(new CompositeProcessEnginePlugin(processEnginePluginsFromContext));
    }
}

