/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.run;

import io.orqueio.bpm.engine.rest.security.auth.ProcessEngineAuthenticationFilter;
import io.orqueio.bpm.run.property.OrqueioBpmRunAuthenticationProperties;
import io.orqueio.bpm.run.property.OrqueioBpmRunProperties;
import io.orqueio.bpm.spring.boot.starter.OrqueioBpmAutoConfiguration;
import io.orqueio.bpm.spring.boot.starter.rest.OrqueioBpmRestInitializer;
import io.orqueio.bpm.spring.boot.starter.rest.OrqueioJerseyResourceConfig;
import jakarta.servlet.Filter;
import java.util.Collections;
import org.apache.catalina.filters.CorsFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.servlet.JerseyApplicationPath;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@EnableConfigurationProperties(value={OrqueioBpmRunProperties.class})
@Configuration
@AutoConfigureAfter(value={OrqueioBpmAutoConfiguration.class})
@ConditionalOnClass(value={OrqueioBpmRestInitializer.class})
public class OrqueioBpmRunRestConfiguration {
    @Autowired
    OrqueioBpmRunProperties orqueioBpmRunProperties;
    private static int CORS_FILTER_PRECEDENCE = 0;
    private static int AUTH_FILTER_PRECEDENCE = 1;

    @Bean
    @ConditionalOnProperty(name={"enabled"}, havingValue="true", prefix="camunda.bpm.run.auth")
    public FilterRegistrationBean<Filter> processEngineAuthenticationFilter(JerseyApplicationPath applicationPath) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setName("orqueio-auth");
        registration.setFilter((Filter)new ProcessEngineAuthenticationFilter());
        registration.setOrder(AUTH_FILTER_PRECEDENCE);
        String restApiPathPattern = applicationPath.getUrlMapping();
        registration.addUrlPatterns(new String[]{restApiPathPattern});
        OrqueioBpmRunAuthenticationProperties properties = this.orqueioBpmRunProperties.getAuth();
        if (properties.getAuthentication() == null || "basic".equals(properties.getAuthentication())) {
            registration.addInitParameter("authentication-provider", "io.orqueio.bpm.engine.rest.security.auth.impl.HttpBasicAuthenticationProvider");
        }
        return registration;
    }

    @Bean
    @ConditionalOnProperty(name={"enabled"}, havingValue="true", prefix="camunda.bpm.run.cors")
    public FilterRegistrationBean<Filter> corsFilter(JerseyApplicationPath applicationPath) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setName("orqueio-cors");
        CorsFilter corsFilter = new CorsFilter();
        registration.setFilter((Filter)corsFilter);
        registration.setOrder(CORS_FILTER_PRECEDENCE);
        String restApiPathPattern = applicationPath.getUrlMapping();
        registration.addUrlPatterns(new String[]{restApiPathPattern});
        registration.addInitParameter("cors.allowed.origins", this.orqueioBpmRunProperties.getCors().getAllowedOrigins());
        registration.addInitParameter("cors.allowed.methods", "GET,POST,HEAD,OPTIONS,PUT,DELETE");
        registration.addInitParameter("cors.allowed.headers", this.orqueioBpmRunProperties.getCors().getAllowedHeaders());
        registration.addInitParameter("cors.exposed.headers", this.orqueioBpmRunProperties.getCors().getExposedHeaders());
        registration.addInitParameter("cors.support.credentials", String.valueOf(this.orqueioBpmRunProperties.getCors().getAllowCredentials()));
        registration.addInitParameter("cors.preflight.maxage", this.orqueioBpmRunProperties.getCors().getPreflightMaxAge());
        return registration;
    }

    @Bean
    public OrqueioJerseyResourceConfig orqueioRunJerseyResourceConfig() {
        OrqueioJerseyResourceConfig orqueioJerseyResourceConfig = new OrqueioJerseyResourceConfig();
        orqueioJerseyResourceConfig.setProperties(Collections.singletonMap("jersey.config.server.wadl.disableWadl", this.orqueioBpmRunProperties.getRest().isDisableWadl()));
        return orqueioJerseyResourceConfig;
    }
}

