/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.admin.impl.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.AuthorizationService;
import io.orqueio.bpm.engine.IdentityService;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.authorization.Authorization;
import io.orqueio.bpm.engine.authorization.Permission;
import io.orqueio.bpm.engine.authorization.Permissions;
import io.orqueio.bpm.engine.authorization.Resource;
import io.orqueio.bpm.engine.authorization.Resources;
import io.orqueio.bpm.engine.identity.Group;
import io.orqueio.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import io.orqueio.bpm.engine.rest.dto.identity.UserDto;
import io.orqueio.bpm.engine.rest.impl.UserRestServiceImpl;
import io.orqueio.bpm.engine.rest.spi.ProcessEngineProvider;
import io.orqueio.bpm.engine.rest.util.ProvidersUtil;
import io.orqueio.bpm.webapp.impl.WebappLogger;
import io.orqueio.bpm.webapp.impl.security.SecurityActions;
import jakarta.servlet.ServletException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.util.Iterator;
import java.util.ServiceLoader;

@Path(value="/setup/{engine}")
public class SetupResource {
    protected static final WebappLogger LOGGER = WebappLogger.INSTANCE;
    @Context
    protected Providers providers;

    @Path(value="/user/create")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void createInitialUser(final @PathParam(value="engine") String processEngineName, final UserDto user) throws IOException, ServletException {
        final ProcessEngine processEngine = this.lookupProcessEngine(processEngineName);
        if (processEngine == null) {
            throw LOGGER.invalidRequestEngineNotFoundForName(processEngineName);
        }
        SecurityActions.runWithoutAuthentication(new SecurityActions.SecurityAction<Void>(){

            @Override
            public Void execute() {
                SetupResource.this.createInitialUserInternal(processEngineName, user, processEngine);
                return null;
            }
        }, processEngine);
    }

    protected void createInitialUserInternal(String processEngineName, UserDto user, ProcessEngine processEngine) {
        ObjectMapper objectMapper = this.getObjectMapper();
        this.ensureSetupAvailable(processEngine);
        UserRestServiceImpl userRestServiceImpl = new UserRestServiceImpl(processEngineName, objectMapper);
        userRestServiceImpl.createUser(user);
        this.ensureOrqueioAdminGroupExists(processEngine);
        processEngine.getIdentityService().createMembership(user.getProfile().getId(), "orqueio-admin");
    }

    protected ObjectMapper getObjectMapper() {
        if (this.providers != null) {
            return (ObjectMapper)ProvidersUtil.resolveFromContext((Providers)this.providers, ObjectMapper.class, (MediaType)MediaType.APPLICATION_JSON_TYPE, this.getClass());
        }
        return null;
    }

    protected void ensureOrqueioAdminGroupExists(ProcessEngine processEngine) {
        IdentityService identityService = processEngine.getIdentityService();
        AuthorizationService authorizationService = processEngine.getAuthorizationService();
        if (identityService.createGroupQuery().groupId("orqueio-admin").count() == 0L) {
            Group orqueioAdminGroup = identityService.newGroup("orqueio-admin");
            orqueioAdminGroup.setName("OrqueIO BPM Administrators");
            orqueioAdminGroup.setType("SYSTEM");
            identityService.saveGroup(orqueioAdminGroup);
        }
        for (Resources resource : Resources.values()) {
            if (authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"orqueio-admin"}).resourceType((Resource)resource).resourceId("*").count() != 0L) continue;
            AuthorizationEntity userAdminAuth = new AuthorizationEntity(1);
            userAdminAuth.setGroupId("orqueio-admin");
            userAdminAuth.setResource((Resource)resource);
            userAdminAuth.setResourceId("*");
            userAdminAuth.addPermission((Permission)Permissions.ALL);
            authorizationService.saveAuthorization((Authorization)userAdminAuth);
        }
    }

    protected void ensureSetupAvailable(ProcessEngine processEngine) {
        if (processEngine.getIdentityService().isReadOnly() || processEngine.getIdentityService().createUserQuery().memberOfGroup("orqueio-admin").count() > 0L) {
            throw LOGGER.setupActionNotAvailable();
        }
    }

    protected ProcessEngine lookupProcessEngine(String engineName) {
        ServiceLoader<ProcessEngineProvider> serviceLoader = ServiceLoader.load(ProcessEngineProvider.class);
        Iterator<ProcessEngineProvider> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            ProcessEngineProvider provider = iterator.next();
            return provider.getProcessEngine(engineName);
        }
        throw LOGGER.processEngineProviderNotFound();
    }
}

