/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.cockpit.impl;

import io.orqueio.bpm.cockpit.CockpitRuntimeDelegate;
import io.orqueio.bpm.cockpit.db.CommandExecutor;
import io.orqueio.bpm.cockpit.db.QueryService;
import io.orqueio.bpm.cockpit.impl.db.CommandExecutorImpl;
import io.orqueio.bpm.cockpit.impl.db.QueryServiceImpl;
import io.orqueio.bpm.cockpit.impl.plugin.DefaultPluginRegistry;
import io.orqueio.bpm.cockpit.plugin.PluginRegistry;
import io.orqueio.bpm.cockpit.plugin.spi.CockpitPlugin;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.ProcessEngineException;
import io.orqueio.bpm.engine.impl.ProcessEngineImpl;
import io.orqueio.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.orqueio.bpm.webapp.impl.AbstractAppRuntimeDelegate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultCockpitRuntimeDelegate
extends AbstractAppRuntimeDelegate<CockpitPlugin>
implements CockpitRuntimeDelegate {
    private Map<String, CommandExecutor> commandExecutors = new HashMap<String, CommandExecutor>();

    public DefaultCockpitRuntimeDelegate() {
        super(CockpitPlugin.class);
    }

    @Override
    public QueryService getQueryService(String processEngineName) {
        CommandExecutor commandExecutor = this.getCommandExecutor(processEngineName);
        return new QueryServiceImpl(commandExecutor);
    }

    @Override
    public CommandExecutor getCommandExecutor(String processEngineName) {
        CommandExecutor commandExecutor = this.commandExecutors.get(processEngineName);
        if (commandExecutor == null) {
            commandExecutor = this.createCommandExecutor(processEngineName);
            this.commandExecutors.put(processEngineName, commandExecutor);
        }
        return commandExecutor;
    }

    @Override
    @Deprecated
    public PluginRegistry getPluginRegistry() {
        return new DefaultPluginRegistry(this.pluginRegistry);
    }

    protected List<String> getMappingFiles() {
        List cockpitPlugins = this.pluginRegistry.getPlugins();
        ArrayList<String> mappingFiles = new ArrayList<String>();
        for (CockpitPlugin plugin : cockpitPlugins) {
            mappingFiles.addAll(plugin.getMappingFiles());
        }
        return mappingFiles;
    }

    protected CommandExecutor createCommandExecutor(String processEngineName) {
        ProcessEngine processEngine = this.getProcessEngine(processEngineName);
        if (processEngine == null) {
            throw new ProcessEngineException("No process engine with name " + processEngineName + " found.");
        }
        ProcessEngineConfigurationImpl processEngineConfiguration = ((ProcessEngineImpl)processEngine).getProcessEngineConfiguration();
        List<String> mappingFiles = this.getMappingFiles();
        return new CommandExecutorImpl(processEngineConfiguration, mappingFiles);
    }
}

