/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.cockpit.impl.plugin.base.dto.query;

import io.orqueio.bpm.cockpit.impl.plugin.base.dto.ProcessDefinitionDto;
import io.orqueio.bpm.cockpit.rest.dto.AbstractRestQueryParametersDto;
import io.orqueio.bpm.engine.impl.QueryVariableValue;
import io.orqueio.bpm.engine.impl.variable.serializer.VariableSerializers;
import io.orqueio.bpm.engine.rest.dto.ConditionQueryParameterDto;
import io.orqueio.bpm.engine.rest.dto.OrqueioQueryParam;
import io.orqueio.bpm.engine.rest.dto.VariableQueryParameterDto;
import io.orqueio.bpm.engine.rest.dto.converter.StringArrayConverter;
import io.orqueio.bpm.engine.rest.dto.converter.VariableListConverter;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.List;

public class ProcessDefinitionQueryDto
extends AbstractRestQueryParametersDto<ProcessDefinitionDto> {
    private static final long serialVersionUID = 1L;
    protected String parentProcessDefinitionId;
    protected String superProcessDefinitionId;
    protected String[] activityIdIn;
    protected String businessKey;
    private List<VariableQueryParameterDto> variables;
    private List<QueryVariableValue> queryVariableValues;

    public ProcessDefinitionQueryDto() {
    }

    public ProcessDefinitionQueryDto(MultivaluedMap<String, String> queryParameters) {
        super(queryParameters);
    }

    public String getParentProcessDefinitionId() {
        return this.parentProcessDefinitionId;
    }

    @OrqueioQueryParam(value="parentProcessDefinitionId")
    public void setParentProcessDefinitionId(String parentProcessDefinitionId) {
        this.parentProcessDefinitionId = parentProcessDefinitionId;
    }

    public String getSuperProcessDefinitionId() {
        return this.superProcessDefinitionId;
    }

    @OrqueioQueryParam(value="superProcessDefinitionId")
    public void setSuperProcessDefinitionId(String superProcessDefinitionId) {
        this.superProcessDefinitionId = superProcessDefinitionId;
    }

    public String[] getActivityIdIn() {
        return this.activityIdIn;
    }

    @OrqueioQueryParam(value="activityIdIn", converter=StringArrayConverter.class)
    public void setActivityIdIn(String[] activityIdIn) {
        this.activityIdIn = activityIdIn;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    @OrqueioQueryParam(value="businessKey")
    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    @OrqueioQueryParam(value="variables", converter=VariableListConverter.class)
    public void setVariables(List<VariableQueryParameterDto> variables) {
        this.variables = variables;
    }

    public List<QueryVariableValue> getQueryVariableValues() {
        return this.queryVariableValues;
    }

    public void initQueryVariableValues(VariableSerializers variableTypes, String dbType) {
        this.queryVariableValues = this.createQueryVariableValues(variableTypes, this.variables, dbType);
    }

    @Override
    protected String getOrderByValue(String sortBy) {
        return super.getOrderBy();
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return false;
    }

    private List<QueryVariableValue> createQueryVariableValues(VariableSerializers variableTypes, List<VariableQueryParameterDto> variables, String dbType) {
        ArrayList<QueryVariableValue> values = new ArrayList<QueryVariableValue>();
        if (variables == null) {
            return values;
        }
        for (VariableQueryParameterDto variable : variables) {
            QueryVariableValue value = new QueryVariableValue(variable.getName(), this.resolveVariableValue(variable.getValue()), ConditionQueryParameterDto.getQueryOperator((String)variable.getOperator()), false);
            value.initialize(variableTypes, dbType);
            values.add(value);
        }
        return values;
    }
}

