/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.cockpit.impl.plugin.resources;

import io.orqueio.bpm.cockpit.db.QueryParameters;
import io.orqueio.bpm.cockpit.impl.plugin.base.dto.ProcessDefinitionStatisticsDto;
import io.orqueio.bpm.cockpit.impl.plugin.base.dto.query.ProcessDefinitionStatisticsQueryDto;
import io.orqueio.bpm.cockpit.impl.plugin.base.sub.resources.ProcessDefinitionResource;
import io.orqueio.bpm.cockpit.plugin.resource.AbstractPluginResource;
import io.orqueio.bpm.engine.authorization.Permission;
import io.orqueio.bpm.engine.authorization.Permissions;
import io.orqueio.bpm.engine.authorization.Resource;
import io.orqueio.bpm.engine.authorization.Resources;
import io.orqueio.bpm.engine.rest.dto.CountResultDto;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;

public class ProcessDefinitionRestService
extends AbstractPluginResource {
    public static final String PATH = "/process-definition";

    public ProcessDefinitionRestService(String engineName) {
        super(engineName);
    }

    @Path(value="/{id}")
    public ProcessDefinitionResource getProcessDefinition(@PathParam(value="id") String id) {
        return new ProcessDefinitionResource(this.getProcessEngine().getName(), id);
    }

    @GET
    @Path(value="/statistics-count")
    @Produces(value={"application/json"})
    public CountResultDto getStatisticsCount(@Context UriInfo uriInfo) {
        ProcessDefinitionStatisticsQueryDto queryDto = new ProcessDefinitionStatisticsQueryDto((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        this.configureExecutionQuery(queryDto);
        long count = this.getQueryService().executeQueryRowCount("selectPDStatisticsCount", queryDto);
        return new CountResultDto(count);
    }

    @GET
    @Path(value="/statistics")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public List<ProcessDefinitionStatisticsDto> queryStatistics(@Context UriInfo uriInfo, @QueryParam(value="firstResult") Integer firstResult, @QueryParam(value="maxResults") Integer maxResults) {
        ProcessDefinitionStatisticsQueryDto queryDto = new ProcessDefinitionStatisticsQueryDto((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        this.configureExecutionQuery(queryDto);
        queryDto.setFirstResult(firstResult != null && firstResult >= 0 ? firstResult : 0);
        queryDto.setMaxResults(maxResults != null && maxResults > 0 ? maxResults : Integer.MAX_VALUE);
        return this.getQueryService().executeQuery("selectPDStatistics", queryDto);
    }

    protected void configureExecutionQuery(QueryParameters query) {
        this.configureAuthorizationCheck(query);
        this.configureTenantCheck(query);
        this.addPermissionCheck(query, (Resource)Resources.PROCESS_DEFINITION, "RES.KEY_", (Permission)Permissions.READ);
    }
}

