/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.webapp.impl;

import io.orqueio.bpm.engine.rest.exception.InvalidRequestException;
import io.orqueio.bpm.engine.rest.exception.RestException;
import io.orqueio.bpm.engine.rest.spi.ProcessEngineProvider;
import io.orqueio.commons.logging.BaseLogger;
import jakarta.ws.rs.core.Response;
import java.util.Date;

public class WebappLogger
extends BaseLogger {
    public static final String PROJECT_CODE = "WEBAPP";
    public static final WebappLogger INSTANCE = (WebappLogger)BaseLogger.createLogger(WebappLogger.class, (String)"WEBAPP", (String)"io.orqueio.bpm.webapp", (String)"00");

    public InvalidRequestException invalidRequestEngineNotFoundForName(String engineName) {
        return new InvalidRequestException(Response.Status.BAD_REQUEST, "Process engine with name " + engineName + " does not exist");
    }

    public InvalidRequestException setupActionNotAvailable() {
        return new InvalidRequestException(Response.Status.FORBIDDEN, "Setup action not available");
    }

    public RestException processEngineProviderNotFound() {
        return new RestException(Response.Status.BAD_REQUEST, "Could not find an implementation of the " + String.valueOf(ProcessEngineProvider.class) + "- SPI");
    }

    public void infoWebappSuccessfulLogin(String username) {
        this.logInfo("001", "Successful login for user {}.", new Object[]{username});
    }

    public void infoWebappFailedLogin(String username, String reason) {
        this.logInfo("002", "Failed login attempt for user {}. Reason: {}", new Object[]{username, reason});
    }

    public void infoWebappLogout(String username) {
        this.logInfo("003", "Successful logout for user {}.", new Object[]{username});
    }

    public void traceCacheValidationTime(Date cacheValidationTime) {
        this.logTrace("004", "Cache validation time: {}", new Object[]{cacheValidationTime});
    }

    public void traceCacheValidationTimeUpdated(Date cacheValidationTime, Date newCacheValidationTime) {
        this.logTrace("005", "Cache validation time updated from: {} to: {}", new Object[]{cacheValidationTime, newCacheValidationTime});
    }

    public void traceAuthenticationUpdated(String engineName) {
        this.logTrace("006", "Authentication updated: {}", new Object[]{engineName});
    }

    public void traceAuthenticationRemoved(String engineName) {
        this.logTrace("007", "Authentication removed: {}", new Object[]{engineName});
    }
}

