/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.webapp.impl.db;

import io.orqueio.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.orqueio.bpm.engine.impl.cfg.StandaloneProcessEngineConfiguration;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class QuerySessionFactory
extends StandaloneProcessEngineConfiguration {
    protected static final String[] DEFAULT_MAPPING_FILES = new String[]{"io/orqueio/bpm/engine/impl/mapping/entity/Commons.xml", "io/orqueio/bpm/engine/impl/mapping/entity/Authorization.xml", "io/orqueio/bpm/engine/impl/mapping/entity/Tenant.xml"};
    private List<String> mappingFiles;
    protected ProcessEngineConfigurationImpl wrappedConfiguration;

    protected void init() {
        throw new IllegalArgumentException("Normal 'init' on process engine only used for extended MyBatis mappings is not allowed, please use 'initFromProcessEngineConfiguration'. You cannot construct a process engine with this configuration.");
    }

    public void initFromProcessEngineConfiguration(ProcessEngineConfigurationImpl processEngineConfiguration, List<String> mappings) {
        this.wrappedConfiguration = processEngineConfiguration;
        this.mappingFiles = mappings;
        this.setDatabaseType(processEngineConfiguration.getDatabaseType());
        this.setDataSource(processEngineConfiguration.getDataSource());
        this.setDatabaseTablePrefix(processEngineConfiguration.getDatabaseTablePrefix());
        this.setSkipIsolationLevelCheck(processEngineConfiguration.getSkipIsolationLevelCheck());
        this.setHistoryLevel(processEngineConfiguration.getHistoryLevel());
        this.setHistory(processEngineConfiguration.getHistory());
        this.initDataSource();
        this.initSerialization();
        this.initCommandContextFactory();
        this.initTransactionFactory();
        this.initTransactionContextFactory();
        this.initCommandExecutors();
        this.initIdentityProviderSessionFactory();
        this.initSqlSessionFactory();
        this.initSessionFactories();
        this.initValueTypeResolver();
    }

    public boolean isAuthorizationEnabled() {
        return this.wrappedConfiguration.isAuthorizationEnabled();
    }

    public String getAuthorizationCheckRevokes() {
        return this.wrappedConfiguration.getAuthorizationCheckRevokes();
    }

    protected InputStream getMyBatisXmlConfigurationSteam() {
        String str = this.buildMappings(this.mappingFiles);
        return new ByteArrayInputStream(str.getBytes());
    }

    protected String buildMappings(List<String> mappingFiles) {
        ArrayList<String> mappings = new ArrayList<String>(mappingFiles);
        mappings.addAll(Arrays.asList(DEFAULT_MAPPING_FILES));
        StringBuilder builder = new StringBuilder();
        for (String mappingFile : mappings) {
            builder.append(String.format("<mapper resource=\"%s\" />\n", mappingFile));
        }
        String mappingsFileTemplate = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<!DOCTYPE configuration PUBLIC \"-//mybatis.org//DTD Config 3.0//EN\" \"http://mybatis.org/dtd/mybatis-3-config.dtd\">\n\n<configuration>\n\t<settings>\n\t\t<setting name=\"lazyLoadingEnabled\" value=\"false\" />\n\t</settings>\n\t<mappers>\n%s\n\t</mappers>\n</configuration>";
        return String.format(mappingsFileTemplate, builder.toString());
    }

    public ProcessEngineConfigurationImpl getWrappedConfiguration() {
        return this.wrappedConfiguration;
    }
}

