/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.webapp.impl.security.filter;

import io.orqueio.bpm.cockpit.Cockpit;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.webapp.impl.security.auth.Authentication;
import io.orqueio.bpm.webapp.impl.security.auth.Authentications;
import io.orqueio.bpm.webapp.impl.security.auth.UserAuthentication;
import io.orqueio.bpm.webapp.impl.security.filter.Authorization;
import io.orqueio.bpm.webapp.impl.security.filter.RequestAuthorizer;
import java.util.Map;

public class ApplicationRequestAuthorizer
implements RequestAuthorizer {
    @Override
    public Authorization authorize(Map<String, String> parameters) {
        Authentications authentications = Authentications.getCurrent();
        if (authentications == null) {
            return this.grantAnnonymous();
        }
        String engineName = parameters.get("engine");
        String appName = parameters.get("app");
        Authentication engineAuth = authentications.getAuthenticationForProcessEngine(engineName);
        if (engineAuth == null) {
            return this.grantAnnonymous();
        }
        ProcessEngine processEngine = Cockpit.getProcessEngine(engineName);
        if (processEngine == null) {
            return this.grantAnnonymous();
        }
        if (engineAuth instanceof UserAuthentication) {
            UserAuthentication userAuth = (UserAuthentication)engineAuth;
            if (userAuth.isAuthorizedForApp(appName)) {
                return Authorization.granted(userAuth).forApplication(appName);
            }
            return Authorization.denied(userAuth).forApplication(appName);
        }
        return Authorization.denied(Authentication.ANONYMOUS);
    }

    private Authorization grantAnnonymous() {
        return Authorization.granted(Authentication.ANONYMOUS);
    }
}

