/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.webapp.impl.security.filter;

import io.orqueio.bpm.webapp.impl.security.filter.Authorization;
import io.orqueio.bpm.webapp.impl.security.filter.RequestAuthorizer;
import io.orqueio.bpm.webapp.impl.security.filter.RequestFilter;
import java.util.Map;

public class RequestMatcher {
    private final RequestFilter filter;
    private final RequestAuthorizer authorizer;

    public RequestMatcher(RequestFilter filter, RequestAuthorizer authorizer) {
        this.filter = filter;
        this.authorizer = authorizer;
    }

    public Match match(String requestMethod, String requestUri) {
        Map<String, String> match = this.filter.match(requestMethod, requestUri);
        if (match != null) {
            return new Match(match, this.authorizer);
        }
        return null;
    }

    public static class Match {
        private final Map<String, String> parameters;
        private final RequestAuthorizer authorizer;

        public Match(Map<String, String> parameters, RequestAuthorizer authorizer) {
            this.parameters = parameters;
            this.authorizer = authorizer;
        }

        public Authorization authorize() {
            return this.authorizer.authorize(this.parameters);
        }
    }
}

