/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.webapp.impl.security.filter.headersec;

import io.orqueio.bpm.webapp.impl.security.filter.headersec.provider.HeaderSecurityProvider;
import io.orqueio.bpm.webapp.impl.security.filter.headersec.provider.impl.ContentSecurityPolicyProvider;
import io.orqueio.bpm.webapp.impl.security.filter.headersec.provider.impl.ContentTypeOptionsProvider;
import io.orqueio.bpm.webapp.impl.security.filter.headersec.provider.impl.StrictTransportSecurityProvider;
import io.orqueio.bpm.webapp.impl.security.filter.headersec.provider.impl.XssProtectionProvider;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HttpHeaderSecurityFilter
implements Filter {
    protected final List<HeaderSecurityProvider> headerSecurityProviders = new ArrayList<HeaderSecurityProvider>(){
        {
            this.add(new XssProtectionProvider());
            this.add(new ContentSecurityPolicyProvider());
            this.add(new ContentTypeOptionsProvider());
            this.add(new StrictTransportSecurityProvider());
        }
    };

    public void init(FilterConfig filterConfig) {
        for (HeaderSecurityProvider provider : this.headerSecurityProviders) {
            Map<String, String> filterParams = provider.initParams();
            for (Map.Entry<String, String> filterParam : filterParams.entrySet()) {
                String key = filterParam.getKey();
                String value = filterConfig.getInitParameter(key);
                if (value == null) continue;
                filterParam.setValue(value);
            }
            provider.parseParams();
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (response instanceof HttpServletResponse) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            for (HeaderSecurityProvider provider : this.headerSecurityProviders) {
                if (provider.isDisabled()) continue;
                String headerName = provider.getHeaderName();
                String headerValue = provider.getHeaderValue(request.getServletContext());
                httpResponse.setHeader(headerName, headerValue);
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

