/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.webapp.impl.security.filter.headersec.provider.impl;

import io.orqueio.bpm.webapp.impl.security.filter.headersec.provider.HeaderSecurityProvider;
import io.orqueio.bpm.webapp.impl.util.ServletFilterUtil;
import jakarta.servlet.ServletContext;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

public class ContentSecurityPolicyProvider
extends HeaderSecurityProvider {
    public static final String HEADER_NAME = "Content-Security-Policy";
    public static final String HEADER_NONCE_PLACEHOLDER = "$NONCE";
    public static final String HEADER_DEFAULT_VALUE = "base-uri 'self';script-src $NONCE 'strict-dynamic' 'unsafe-eval' https: 'self' 'unsafe-inline';style-src 'unsafe-inline' 'self';default-src 'self';img-src 'self' data:;block-all-mixed-content;form-action 'self';frame-ancestors 'none';object-src 'none';sandbox allow-forms allow-scripts allow-same-origin allow-popups allow-downloads";
    public static final String DISABLED_PARAM = "contentSecurityPolicyDisabled";
    public static final String VALUE_PARAM = "contentSecurityPolicyValue";
    public static final String ATTR_CSP_FILTER_NONCE = "io.orqueio.bpm.csp.nonce";
    public static final Base64.Encoder ENCODER = Base64.getUrlEncoder().withoutPadding();

    @Override
    public Map<String, String> initParams() {
        this.initParams.put(VALUE_PARAM, null);
        this.initParams.put(DISABLED_PARAM, null);
        return this.initParams;
    }

    @Override
    public void parseParams() {
        String disabled = (String)this.initParams.get(DISABLED_PARAM);
        if (ServletFilterUtil.isEmpty(disabled)) {
            this.setDisabled(false);
        } else {
            this.setDisabled(Boolean.parseBoolean(disabled));
        }
        String value = (String)this.initParams.get(VALUE_PARAM);
        if (!ServletFilterUtil.isEmpty(value)) {
            value = this.normalizeString(value);
            this.setValue(value);
        } else {
            this.setValue(HEADER_DEFAULT_VALUE);
        }
    }

    protected String normalizeString(String value) {
        return value.trim().replaceAll("\\s+", " ");
    }

    @Override
    public String getHeaderName() {
        return HEADER_NAME;
    }

    @Override
    public String getHeaderValue(ServletContext servletContext) {
        String nonce = this.generateNonce();
        servletContext.setAttribute(ATTR_CSP_FILTER_NONCE, (Object)nonce);
        return this.value.replaceAll("\\$NONCE", String.format("'nonce-%s'", nonce));
    }

    protected String generateNonce() {
        byte[] bytes = new byte[20];
        ThreadLocalRandom.current().nextBytes(bytes);
        return ENCODER.encodeToString(bytes);
    }
}

