/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.rest.dto.OrqueioQueryParam;
import io.orqueio.bpm.engine.rest.dto.converter.JacksonAwareStringToTypeConverter;
import io.orqueio.bpm.engine.rest.exception.InvalidRequestException;
import io.orqueio.bpm.engine.rest.exception.RestException;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractSearchQueryDto {
    protected ObjectMapper objectMapper;

    public AbstractSearchQueryDto() {
    }

    public AbstractSearchQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        this.objectMapper = objectMapper;
        for (Map.Entry param : queryParameters.entrySet()) {
            String key = (String)param.getKey();
            String value = (String)((List)param.getValue()).iterator().next();
            this.setValueBasedOnAnnotation(key, value);
        }
    }

    @JsonIgnore
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    protected void setValueBasedOnAnnotation(String key, String value) {
        List<Method> matchingMethods = this.findMatchingAnnotatedMethods(key);
        for (Method method : matchingMethods) {
            Class<JacksonAwareStringToTypeConverter<?>> converterClass = this.findAnnotatedTypeConverter(method);
            if (converterClass == null) continue;
            JacksonAwareStringToTypeConverter<?> converter = null;
            try {
                converter = converterClass.newInstance();
                converter.setObjectMapper(this.objectMapper);
                Object convertedValue = converter.convertQueryParameterToType(value);
                method.invoke((Object)this, convertedValue);
            }
            catch (InstantiationException e) {
                throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e, "Server error.");
            }
            catch (IllegalAccessException e) {
                throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e, "Server error.");
            }
            catch (InvocationTargetException e) {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, e, "Cannot set query parameter '" + key + "' to value '" + value + "'");
            }
            catch (RestException e) {
                throw new InvalidRequestException(e.getStatus(), e, "Cannot set query parameter '" + key + "' to value '" + value + "': " + e.getMessage());
            }
        }
    }

    private List<Method> findMatchingAnnotatedMethods(String parameterName) {
        ArrayList<Method> result = new ArrayList<Method>();
        Method[] methods = this.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            Annotation[] methodAnnotations = method.getAnnotations();
            for (int j = 0; j < methodAnnotations.length; ++j) {
                OrqueioQueryParam parameterAnnotation;
                Annotation annotation = methodAnnotations[j];
                if (!(annotation instanceof OrqueioQueryParam) || !(parameterAnnotation = (OrqueioQueryParam)annotation).value().equals(parameterName)) continue;
                result.add(method);
            }
        }
        return result;
    }

    private Class<? extends JacksonAwareStringToTypeConverter<?>> findAnnotatedTypeConverter(Method method) {
        Annotation[] methodAnnotations = method.getAnnotations();
        for (int j = 0; j < methodAnnotations.length; ++j) {
            Annotation annotation = methodAnnotations[j];
            if (!(annotation instanceof OrqueioQueryParam)) continue;
            OrqueioQueryParam parameterAnnotation = (OrqueioQueryParam)annotation;
            return parameterAnnotation.converter();
        }
        return null;
    }
}

