/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.dto;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.impl.digest._apacheCommonsCodec.Base64;
import io.orqueio.bpm.engine.rest.exception.InvalidRequestException;
import io.orqueio.bpm.engine.rest.exception.RestException;
import io.orqueio.bpm.engine.rest.mapper.MultipartFormData;
import io.orqueio.bpm.engine.variable.VariableMap;
import io.orqueio.bpm.engine.variable.Variables;
import io.orqueio.bpm.engine.variable.type.FileValueType;
import io.orqueio.bpm.engine.variable.type.PrimitiveValueType;
import io.orqueio.bpm.engine.variable.type.SerializableValueType;
import io.orqueio.bpm.engine.variable.type.ValueType;
import io.orqueio.bpm.engine.variable.type.ValueTypeResolver;
import io.orqueio.bpm.engine.variable.value.FileValue;
import io.orqueio.bpm.engine.variable.value.SerializableValue;
import io.orqueio.bpm.engine.variable.value.TypedValue;
import jakarta.activation.MimeType;
import jakarta.activation.MimeTypeParseException;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Map;

public class VariableValueDto {
    protected String type;
    protected Object value;
    protected Map<String, Object> valueInfo;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Map<String, Object> getValueInfo() {
        return this.valueInfo;
    }

    public void setValueInfo(Map<String, Object> valueInfo) {
        this.valueInfo = valueInfo;
    }

    public TypedValue toTypedValue(ProcessEngine processEngine, ObjectMapper objectMapper) {
        ValueTypeResolver valueTypeResolver = processEngine.getProcessEngineConfiguration().getValueTypeResolver();
        if (this.type == null) {
            if (this.valueInfo != null && this.valueInfo.get("transient") instanceof Boolean) {
                return Variables.untypedValue((Object)this.value, (boolean)((Boolean)this.valueInfo.get("transient")));
            }
            return Variables.untypedValue((Object)this.value);
        }
        ValueType valueType = valueTypeResolver.typeForName(VariableValueDto.fromRestApiTypeName(this.type));
        if (valueType == null) {
            throw new RestException(Response.Status.BAD_REQUEST, String.format("Unsupported value type '%s'", this.type));
        }
        if (valueType instanceof PrimitiveValueType) {
            PrimitiveValueType primitiveValueType = (PrimitiveValueType)valueType;
            Class javaType = primitiveValueType.getJavaType();
            Object mappedValue = null;
            try {
                if (this.value != null) {
                    mappedValue = javaType.isAssignableFrom(this.value.getClass()) ? this.value : objectMapper.readValue("\"" + String.valueOf(this.value) + "\"", javaType);
                }
                return valueType.createValue(mappedValue, this.valueInfo);
            }
            catch (Exception e) {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, e, String.format("Cannot convert value '%s' of type '%s' to java type %s", this.value, this.type, javaType.getName()));
            }
        }
        if (valueType instanceof SerializableValueType) {
            if (this.value != null && !(this.value instanceof String)) {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Must provide 'null' or String value for value of SerializableValue type '" + this.type + "'.");
            }
            return ((SerializableValueType)valueType).createValueFromSerialized((String)this.value, this.valueInfo);
        }
        if (valueType instanceof FileValueType) {
            if (this.value instanceof String) {
                this.value = Base64.decodeBase64((String)((String)this.value));
            }
            return valueType.createValue(this.value, this.valueInfo);
        }
        return valueType.createValue(this.value, this.valueInfo);
    }

    protected FileValue fileValueWithDecodedString(FileValue fileValue, String value) {
        return (FileValue)Variables.fileValue((String)fileValue.getFilename()).file(Base64.decodeBase64((String)value)).mimeType(fileValue.getMimeType()).encoding(fileValue.getEncoding()).create();
    }

    public static VariableMap toMap(Map<String, VariableValueDto> variables, ProcessEngine processEngine, ObjectMapper objectMapper) {
        if (variables == null) {
            return null;
        }
        VariableMap result = Variables.createVariables();
        for (Map.Entry<String, VariableValueDto> variableEntry : variables.entrySet()) {
            result.put((Object)variableEntry.getKey(), (Object)variableEntry.getValue().toTypedValue(processEngine, objectMapper));
        }
        return result;
    }

    public static Map<String, VariableValueDto> fromMap(VariableMap variables) {
        return VariableValueDto.fromMap(variables, false);
    }

    public static Map<String, VariableValueDto> fromMap(VariableMap variables, boolean preferSerializedValue) {
        HashMap<String, VariableValueDto> result = new HashMap<String, VariableValueDto>();
        for (String variableName : variables.keySet()) {
            VariableValueDto valueDto = VariableValueDto.fromTypedValue(variables.getValueTyped(variableName), preferSerializedValue);
            result.put(variableName, valueDto);
        }
        return result;
    }

    public static VariableValueDto fromTypedValue(TypedValue typedValue) {
        VariableValueDto dto = new VariableValueDto();
        VariableValueDto.fromTypedValue(dto, typedValue);
        return dto;
    }

    public static VariableValueDto fromTypedValue(TypedValue typedValue, boolean preferSerializedValue) {
        VariableValueDto dto = new VariableValueDto();
        VariableValueDto.fromTypedValue(dto, typedValue, preferSerializedValue);
        return dto;
    }

    public static void fromTypedValue(VariableValueDto dto, TypedValue typedValue) {
        VariableValueDto.fromTypedValue(dto, typedValue, false);
    }

    public static void fromTypedValue(VariableValueDto dto, TypedValue typedValue, boolean preferSerializedValue) {
        ValueType type = typedValue.getType();
        if (type != null) {
            String typeName = type.getName();
            dto.setType(VariableValueDto.toRestApiTypeName(typeName));
            dto.setValueInfo(type.getValueInfo(typedValue));
        }
        if (typedValue instanceof SerializableValue) {
            SerializableValue serializableValue = (SerializableValue)typedValue;
            if (serializableValue.isDeserialized() && !preferSerializedValue) {
                dto.setValue(serializableValue.getValue());
            } else {
                dto.setValue(serializableValue.getValueSerialized());
            }
        } else if (!(typedValue instanceof FileValue)) {
            dto.setValue(typedValue.getValue());
        }
    }

    public static String toRestApiTypeName(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static String fromRestApiTypeName(String name) {
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    public static VariableValueDto fromFormPart(String type, MultipartFormData.FormPart binaryDataFormPart) {
        VariableValueDto dto = new VariableValueDto();
        dto.type = type;
        dto.value = binaryDataFormPart.getBinaryContent();
        if (ValueType.FILE.getName().equals(VariableValueDto.fromRestApiTypeName(type))) {
            String transientString;
            boolean isTransient;
            String contentType = binaryDataFormPart.getContentType();
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            dto.valueInfo = new HashMap<String, Object>();
            dto.valueInfo.put("filename", binaryDataFormPart.getFileName());
            MimeType mimeType = null;
            try {
                mimeType = new MimeType(contentType);
            }
            catch (MimeTypeParseException e) {
                throw new RestException(Response.Status.BAD_REQUEST, "Invalid mime type given");
            }
            dto.valueInfo.put("mimeType", mimeType.getBaseType());
            String encoding = mimeType.getParameter("encoding");
            if (encoding != null) {
                dto.valueInfo.put("encoding", encoding);
            }
            if (isTransient = Boolean.parseBoolean(transientString = mimeType.getParameter("transient"))) {
                dto.valueInfo.put("transient", isTransient);
            }
        }
        return dto;
    }
}

