/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.dto.converter;

import io.orqueio.bpm.engine.rest.dto.ConditionQueryParameterDto;
import io.orqueio.bpm.engine.rest.dto.converter.JacksonAwareStringToTypeConverter;
import io.orqueio.bpm.engine.rest.exception.InvalidRequestException;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;

public class ConditionListConverter
extends JacksonAwareStringToTypeConverter<List<ConditionQueryParameterDto>> {
    private static final String EXPRESSION_DELIMITER = ",";
    private static final String ATTRIBUTE_DELIMITER = "_";

    @Override
    public List<ConditionQueryParameterDto> convertQueryParameterToType(String value) {
        String[] expressions = value.split(EXPRESSION_DELIMITER);
        ArrayList<ConditionQueryParameterDto> queryConditions = new ArrayList<ConditionQueryParameterDto>();
        for (String expression : expressions) {
            String[] valueTuple = expression.split(ATTRIBUTE_DELIMITER);
            if (valueTuple.length != 2) {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "condition query parameter has to have format OPERATOR_VALUE.");
            }
            ConditionQueryParameterDto queryCondition = new ConditionQueryParameterDto();
            queryCondition.setOperator(valueTuple[0]);
            queryCondition.setValue(valueTuple[1]);
            queryConditions.add(queryCondition);
        }
        return queryConditions;
    }
}

