/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.dto.externaltask;

import io.orqueio.bpm.engine.ExternalTaskService;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.externaltask.ExternalTaskQueryTopicBuilder;
import io.orqueio.bpm.engine.externaltask.FetchAndLockBuilder;
import io.orqueio.bpm.engine.impl.util.CollectionUtil;
import io.orqueio.bpm.engine.rest.dto.SortingDto;
import io.orqueio.bpm.engine.rest.exception.InvalidRequestException;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class FetchExternalTasksDto {
    protected int maxTasks;
    protected String workerId;
    protected boolean usePriority = false;
    protected List<FetchExternalTaskTopicDto> topics;
    protected boolean includeExtensionProperties = false;
    protected List<SortingDto> sorting;

    public int getMaxTasks() {
        return this.maxTasks;
    }

    public void setMaxTasks(int maxTasks) {
        this.maxTasks = maxTasks;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    public List<FetchExternalTaskTopicDto> getTopics() {
        return this.topics;
    }

    public void setTopics(List<FetchExternalTaskTopicDto> topics) {
        this.topics = topics;
    }

    public boolean isUsePriority() {
        return this.usePriority;
    }

    public void setUsePriority(boolean usePriority) {
        this.usePriority = usePriority;
    }

    public void setSorting(List<SortingDto> sorting) {
        this.sorting = sorting;
    }

    public List<SortingDto> getSorting() {
        return this.sorting;
    }

    public boolean isIncludeExtensionProperties() {
        return this.includeExtensionProperties;
    }

    public void setIncludeExtensionProperties(boolean includeExtensionProperties) {
        this.includeExtensionProperties = includeExtensionProperties;
    }

    public ExternalTaskQueryTopicBuilder buildQuery(ProcessEngine processEngine) {
        FetchAndLockBuilder fetchAndLockBuilder = this.getBuilder(processEngine);
        return this.configureTopics(fetchAndLockBuilder);
    }

    protected ExternalTaskQueryTopicBuilder configureTopics(FetchAndLockBuilder builder) {
        ExternalTaskQueryTopicBuilder topicBuilder = builder.subscribe();
        if (CollectionUtil.isEmpty(this.topics)) {
            return topicBuilder;
        }
        this.topics.forEach(topic -> {
            topicBuilder.topic(topic.getTopicName(), topic.getLockDuration());
            if (topic.getBusinessKey() != null) {
                topicBuilder.businessKey(topic.getBusinessKey());
            }
            if (topic.getProcessDefinitionId() != null) {
                topicBuilder.processDefinitionId(topic.getProcessDefinitionId());
            }
            if (topic.getProcessDefinitionIdIn() != null) {
                topicBuilder.processDefinitionIdIn(topic.getProcessDefinitionIdIn());
            }
            if (topic.getProcessDefinitionKey() != null) {
                topicBuilder.processDefinitionKey(topic.getProcessDefinitionKey());
            }
            if (topic.getProcessDefinitionKeyIn() != null) {
                topicBuilder.processDefinitionKeyIn(topic.getProcessDefinitionKeyIn());
            }
            if (topic.getVariables() != null) {
                topicBuilder.variables(topic.getVariables());
            }
            if (topic.getProcessVariables() != null) {
                topicBuilder.processInstanceVariableEquals(topic.getProcessVariables());
            }
            if (topic.isDeserializeValues()) {
                topicBuilder.enableCustomObjectDeserialization();
            }
            if (topic.isLocalVariables()) {
                topicBuilder.localVariables();
            }
            if (Boolean.TRUE.equals(topic.isWithoutTenantId())) {
                topicBuilder.withoutTenantId();
            }
            if (topic.getTenantIdIn() != null) {
                topicBuilder.tenantIdIn(topic.getTenantIdIn());
            }
            if (topic.getProcessDefinitionVersionTag() != null) {
                topicBuilder.processDefinitionVersionTag(topic.getProcessDefinitionVersionTag());
            }
            if (topic.isIncludeExtensionProperties()) {
                topicBuilder.includeExtensionProperties();
            }
        });
        return topicBuilder;
    }

    protected FetchAndLockBuilder getBuilder(ProcessEngine engine) {
        ExternalTaskService service = engine.getExternalTaskService();
        FetchAndLockBuilder builder = service.fetchAndLock().workerId(this.workerId).maxTasks(this.maxTasks).usePriority(this.usePriority);
        SortMapper mapper = new SortMapper(this.sorting, builder);
        return mapper.getBuilderWithSortConfigs();
    }

    static class SortMapper {
        protected static Map<String, Consumer<FetchAndLockBuilder>> FIELD_MAPPINGS = Map.of("createTime", FetchAndLockBuilder::orderByCreateTime);
        protected static Map<String, Consumer<FetchAndLockBuilder>> ORDER_MAPPINGS = Map.of("asc", FetchAndLockBuilder::asc, "desc", FetchAndLockBuilder::desc);
        protected final List<SortingDto> sorting;
        protected final FetchAndLockBuilder builder;

        protected SortMapper(List<SortingDto> sorting, FetchAndLockBuilder builder) {
            this.sorting = sorting == null ? Collections.emptyList() : sorting;
            this.builder = builder;
        }

        protected FetchAndLockBuilder getBuilderWithSortConfigs() {
            for (SortingDto dto : this.sorting) {
                String sortBy = dto.getSortBy();
                this.configureFieldOrBadRequest(sortBy, "sortBy", FIELD_MAPPINGS);
                String sortOrder = dto.getSortOrder();
                if (sortOrder == null) continue;
                this.configureFieldOrBadRequest(sortOrder, "sortOrder", ORDER_MAPPINGS);
            }
            return this.builder;
        }

        protected void configureFieldOrBadRequest(String key, String parameterName, Map<String, Consumer<FetchAndLockBuilder>> fieldMappings) {
            if (!fieldMappings.containsKey(key)) {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Cannot set query " + parameterName + " parameter to value " + key);
            }
            fieldMappings.get(key).accept(this.builder);
        }
    }

    public static class FetchExternalTaskTopicDto {
        protected String topicName;
        protected String businessKey;
        protected String processDefinitionId;
        protected String[] processDefinitionIdIn;
        protected String processDefinitionKey;
        protected String[] processDefinitionKeyIn;
        protected String processDefinitionVersionTag;
        protected long lockDuration;
        protected List<String> variables;
        protected HashMap<String, Object> processVariables;
        protected boolean deserializeValues = false;
        protected boolean localVariables = false;
        protected boolean includeExtensionProperties = false;
        protected boolean withoutTenantId;
        protected String[] tenantIdIn;

        public String getTopicName() {
            return this.topicName;
        }

        public void setTopicName(String topicName) {
            this.topicName = topicName;
        }

        public String getBusinessKey() {
            return this.businessKey;
        }

        public void setBusinessKey(String businessKey) {
            this.businessKey = businessKey;
        }

        public String getProcessDefinitionId() {
            return this.processDefinitionId;
        }

        public void setProcessDefinitionId(String processDefinitionId) {
            this.processDefinitionId = processDefinitionId;
        }

        public String[] getProcessDefinitionIdIn() {
            return this.processDefinitionIdIn;
        }

        public void setProcessDefinitionIdIn(String[] processDefinitionIds) {
            this.processDefinitionIdIn = processDefinitionIds;
        }

        public String getProcessDefinitionKey() {
            return this.processDefinitionKey;
        }

        public void setProcessDefinitionKey(String processDefinitionKey) {
            this.processDefinitionKey = processDefinitionKey;
        }

        public String[] getProcessDefinitionKeyIn() {
            return this.processDefinitionKeyIn;
        }

        public void setProcessDefinitionKeyIn(String[] processDefinitionKeys) {
            this.processDefinitionKeyIn = processDefinitionKeys;
        }

        public String getProcessDefinitionVersionTag() {
            return this.processDefinitionVersionTag;
        }

        public void setProcessDefinitionVersionTag(String processDefinitionVersionTag) {
            this.processDefinitionVersionTag = processDefinitionVersionTag;
        }

        public long getLockDuration() {
            return this.lockDuration;
        }

        public void setLockDuration(long lockDuration) {
            this.lockDuration = lockDuration;
        }

        public List<String> getVariables() {
            return this.variables;
        }

        public void setVariables(List<String> variables) {
            this.variables = variables;
        }

        public HashMap<String, Object> getProcessVariables() {
            return this.processVariables;
        }

        public void setProcessVariables(HashMap<String, Object> processVariables) {
            this.processVariables = processVariables;
        }

        public boolean isDeserializeValues() {
            return this.deserializeValues;
        }

        public void setDeserializeValues(boolean deserializeValues) {
            this.deserializeValues = deserializeValues;
        }

        public boolean isLocalVariables() {
            return this.localVariables;
        }

        public void setLocalVariables(boolean localVariables) {
            this.localVariables = localVariables;
        }

        public boolean isWithoutTenantId() {
            return this.withoutTenantId;
        }

        public void setWithoutTenantId(boolean withoutTenantId) {
            this.withoutTenantId = withoutTenantId;
        }

        public String[] getTenantIdIn() {
            return this.tenantIdIn;
        }

        public void setTenantIdIn(String[] tenantIdIn) {
            this.tenantIdIn = tenantIdIn;
        }

        public boolean isIncludeExtensionProperties() {
            return this.includeExtensionProperties;
        }

        public void setIncludeExtensionProperties(boolean includeExtensionProperties) {
            this.includeExtensionProperties = includeExtensionProperties;
        }
    }
}

