/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.dto.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.history.HistoricProcessInstanceReport;
import io.orqueio.bpm.engine.rest.dto.AbstractReportDto;
import io.orqueio.bpm.engine.rest.dto.OrqueioQueryParam;
import io.orqueio.bpm.engine.rest.dto.converter.DateConverter;
import io.orqueio.bpm.engine.rest.dto.converter.StringArrayConverter;
import io.orqueio.bpm.engine.rest.exception.InvalidRequestException;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class HistoricProcessInstanceReportDto
extends AbstractReportDto<HistoricProcessInstanceReport> {
    protected String[] processDefinitionIdIn;
    protected String[] processDefinitionKeyIn;
    protected Date startedAfter;
    protected Date startedBefore;
    public static final String REPORT_TYPE_DURATION = "duration";
    public static final List<String> VALID_REPORT_TYPE_VALUES = new ArrayList<String>();

    public HistoricProcessInstanceReportDto() {
    }

    public HistoricProcessInstanceReportDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @OrqueioQueryParam(value="processDefinitionIdIn", converter=StringArrayConverter.class)
    public void setProcessDefinitionIdIn(String[] processDefinitionIdIn) {
        this.processDefinitionIdIn = processDefinitionIdIn;
    }

    @OrqueioQueryParam(value="processDefinitionKeyIn", converter=StringArrayConverter.class)
    public void setProcessDefinitionKeyIn(String[] processDefinitionKeyIn) {
        this.processDefinitionKeyIn = processDefinitionKeyIn;
    }

    @OrqueioQueryParam(value="startedAfter", converter=DateConverter.class)
    public void setStartedAfter(Date startedAfter) {
        this.startedAfter = startedAfter;
    }

    @OrqueioQueryParam(value="startedBefore", converter=DateConverter.class)
    public void setStartedBefore(Date startedBefore) {
        this.startedBefore = startedBefore;
    }

    @Override
    protected HistoricProcessInstanceReport createNewReportQuery(ProcessEngine engine) {
        return engine.getHistoryService().createHistoricProcessInstanceReport();
    }

    @Override
    protected void applyFilters(HistoricProcessInstanceReport reportQuery) {
        if (this.processDefinitionIdIn != null && this.processDefinitionIdIn.length > 0) {
            reportQuery.processDefinitionIdIn(this.processDefinitionIdIn);
        }
        if (this.processDefinitionKeyIn != null && this.processDefinitionKeyIn.length > 0) {
            reportQuery.processDefinitionKeyIn(this.processDefinitionKeyIn);
        }
        if (this.startedAfter != null) {
            reportQuery.startedAfter(this.startedAfter);
        }
        if (this.startedBefore != null) {
            reportQuery.startedBefore(this.startedBefore);
        }
        if (!REPORT_TYPE_DURATION.equals(this.reportType)) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Unknown report type " + this.reportType);
        }
    }

    static {
        VALID_REPORT_TYPE_VALUES.add(REPORT_TYPE_DURATION);
    }
}

