/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.dto.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.repository.CaseDefinitionQuery;
import io.orqueio.bpm.engine.rest.dto.AbstractQueryDto;
import io.orqueio.bpm.engine.rest.dto.OrqueioQueryParam;
import io.orqueio.bpm.engine.rest.dto.converter.BooleanConverter;
import io.orqueio.bpm.engine.rest.dto.converter.IntegerConverter;
import io.orqueio.bpm.engine.rest.dto.converter.StringListConverter;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CaseDefinitionQueryDto
extends AbstractQueryDto<CaseDefinitionQuery> {
    private static final String SORT_BY_ID_VALUE = "id";
    private static final String SORT_BY_KEY_VALUE = "key";
    private static final String SORT_BY_NAME_VALUE = "name";
    private static final String SORT_BY_VERSION_VALUE = "version";
    private static final String SORT_BY_DEPLOYMENT_ID_VALUE = "deploymentId";
    private static final String SORT_BY_CATEGORY_VALUE = "category";
    private static final String SORT_BY_TENANT_ID = "tenantId";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected String caseDefinitionId;
    protected List<String> caseDefinitionIdIn;
    protected String category;
    protected String categoryLike;
    protected String name;
    protected String nameLike;
    protected String deploymentId;
    protected String key;
    protected String keyLike;
    protected String resourceName;
    protected String resourceNameLike;
    protected Integer version;
    protected Boolean latestVersion;
    protected List<String> tenantIds;
    protected Boolean withoutTenantId;
    protected Boolean includeDefinitionsWithoutTenantId;

    public CaseDefinitionQueryDto() {
    }

    public CaseDefinitionQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @OrqueioQueryParam(value="caseDefinitionId")
    public void setCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    @OrqueioQueryParam(value="caseDefinitionIdIn", converter=StringListConverter.class)
    public void setCaseDefinitionIdIn(List<String> caseDefinitionIdIn) {
        this.caseDefinitionIdIn = caseDefinitionIdIn;
    }

    @OrqueioQueryParam(value="category")
    public void setCategory(String category) {
        this.category = category;
    }

    @OrqueioQueryParam(value="categoryLike")
    public void setCategoryLike(String categoryLike) {
        this.categoryLike = categoryLike;
    }

    @OrqueioQueryParam(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @OrqueioQueryParam(value="nameLike")
    public void setNameLike(String nameLike) {
        this.nameLike = nameLike;
    }

    @OrqueioQueryParam(value="deploymentId")
    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    @OrqueioQueryParam(value="key")
    public void setKey(String key) {
        this.key = key;
    }

    @OrqueioQueryParam(value="keyLike")
    public void setKeyLike(String keyLike) {
        this.keyLike = keyLike;
    }

    @OrqueioQueryParam(value="resourceName")
    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    @OrqueioQueryParam(value="resourceNameLike")
    public void setResourceNameLike(String resourceNameLike) {
        this.resourceNameLike = resourceNameLike;
    }

    @OrqueioQueryParam(value="version", converter=IntegerConverter.class)
    public void setVersion(Integer version) {
        this.version = version;
    }

    @Deprecated
    @OrqueioQueryParam(value="latest", converter=BooleanConverter.class)
    public void setLatest(Boolean latest) {
        this.setLatestVersion(latest);
    }

    @OrqueioQueryParam(value="latestVersion", converter=BooleanConverter.class)
    public void setLatestVersion(Boolean latestVersion) {
        this.latestVersion = latestVersion;
    }

    @OrqueioQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @OrqueioQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    @OrqueioQueryParam(value="includeCaseDefinitionsWithoutTenantId", converter=BooleanConverter.class)
    public void setIncludeCaseDefinitionsWithoutTenantId(Boolean includeDefinitionsWithoutTenantId) {
        this.includeDefinitionsWithoutTenantId = includeDefinitionsWithoutTenantId;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected CaseDefinitionQuery createNewQuery(ProcessEngine engine) {
        return engine.getRepositoryService().createCaseDefinitionQuery();
    }

    @Override
    protected void applyFilters(CaseDefinitionQuery query) {
        if (this.caseDefinitionId != null) {
            query.caseDefinitionId(this.caseDefinitionId);
        }
        if (this.caseDefinitionIdIn != null && !this.caseDefinitionIdIn.isEmpty()) {
            query.caseDefinitionIdIn(this.caseDefinitionIdIn.toArray(new String[this.caseDefinitionIdIn.size()]));
        }
        if (this.category != null) {
            query.caseDefinitionCategory(this.category);
        }
        if (this.categoryLike != null) {
            query.caseDefinitionCategoryLike(this.categoryLike);
        }
        if (this.name != null) {
            query.caseDefinitionName(this.name);
        }
        if (this.nameLike != null) {
            query.caseDefinitionNameLike(this.nameLike);
        }
        if (this.deploymentId != null) {
            query.deploymentId(this.deploymentId);
        }
        if (this.key != null) {
            query.caseDefinitionKey(this.key);
        }
        if (this.keyLike != null) {
            query.caseDefinitionKeyLike(this.keyLike);
        }
        if (this.resourceName != null) {
            query.caseDefinitionResourceName(this.resourceName);
        }
        if (this.resourceNameLike != null) {
            query.caseDefinitionResourceNameLike(this.resourceNameLike);
        }
        if (this.version != null) {
            query.caseDefinitionVersion(this.version);
        }
        if (Boolean.TRUE.equals(this.latestVersion)) {
            query.latestVersion();
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
        if (Boolean.TRUE.equals(this.includeDefinitionsWithoutTenantId)) {
            query.includeCaseDefinitionsWithoutTenantId();
        }
    }

    @Override
    protected void applySortBy(CaseDefinitionQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_CATEGORY_VALUE)) {
            query.orderByCaseDefinitionCategory();
        } else if (sortBy.equals(SORT_BY_KEY_VALUE)) {
            query.orderByCaseDefinitionKey();
        } else if (sortBy.equals(SORT_BY_ID_VALUE)) {
            query.orderByCaseDefinitionId();
        } else if (sortBy.equals(SORT_BY_VERSION_VALUE)) {
            query.orderByCaseDefinitionVersion();
        } else if (sortBy.equals(SORT_BY_NAME_VALUE)) {
            query.orderByCaseDefinitionName();
        } else if (sortBy.equals(SORT_BY_DEPLOYMENT_ID_VALUE)) {
            query.orderByDeploymentId();
        } else if (sortBy.equals(SORT_BY_TENANT_ID)) {
            query.orderByTenantId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_CATEGORY_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_KEY_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_NAME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_VERSION_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_DEPLOYMENT_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
    }
}

