/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.dto.runtime.modification;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.rest.dto.runtime.modification.ProcessInstanceModificationInstructionDto;
import io.orqueio.bpm.engine.rest.exception.InvalidRequestException;
import io.orqueio.bpm.engine.runtime.InstantiationBuilder;
import io.orqueio.bpm.engine.runtime.ModificationBuilder;
import io.orqueio.bpm.engine.runtime.ProcessInstanceModificationBuilder;
import jakarta.ws.rs.core.Response;

@JsonTypeName(value="cancel")
public class CancellationInstructionDto
extends ProcessInstanceModificationInstructionDto {
    @Override
    public void applyTo(ProcessInstanceModificationBuilder builder, ProcessEngine engine, ObjectMapper mapper) {
        this.validateParameters();
        if (this.activityId != null) {
            builder.cancelAllForActivity(this.activityId);
        } else if (this.activityInstanceId != null) {
            builder.cancelActivityInstance(this.activityInstanceId);
        } else if (this.transitionInstanceId != null) {
            builder.cancelTransitionInstance(this.transitionInstanceId);
        }
    }

    protected void validateParameters() {
        boolean oneParameterSet = false;
        boolean moreThanOneParametersSet = false;
        if (this.activityId != null) {
            oneParameterSet = true;
        }
        if (this.activityInstanceId != null) {
            moreThanOneParametersSet |= oneParameterSet;
            oneParameterSet = true;
        }
        if (this.transitionInstanceId != null) {
            moreThanOneParametersSet |= oneParameterSet;
            oneParameterSet = true;
        }
        if (moreThanOneParametersSet || !oneParameterSet) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, this.buildErrorMessage("exactly one, 'activityId', 'activityInstanceId', or 'transitionInstanceId', is required"));
        }
    }

    @Override
    public void applyTo(InstantiationBuilder<?> builder, ProcessEngine engine, ObjectMapper mapper) {
        if (builder instanceof ModificationBuilder) {
            if (this.activityId == null) {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, this.buildErrorMessage("'activityId' must be set"));
            }
            if (this.cancelCurrentActiveActivityInstances) {
                ((ModificationBuilder)builder).cancelAllForActivity(this.activityId, true);
            } else {
                ((ModificationBuilder)builder).cancelAllForActivity(this.activityId);
            }
        }
    }
}

