/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.hal.identitylink;

import io.orqueio.bpm.engine.rest.GroupRestService;
import io.orqueio.bpm.engine.rest.TaskRestService;
import io.orqueio.bpm.engine.rest.UserRestService;
import io.orqueio.bpm.engine.rest.hal.HalRelation;
import io.orqueio.bpm.engine.rest.hal.HalResource;
import io.orqueio.bpm.engine.task.IdentityLink;
import jakarta.ws.rs.core.UriBuilder;

public class HalIdentityLink
extends HalResource<HalIdentityLink> {
    public static final HalRelation REL_GROUP = HalRelation.build("group", GroupRestService.class, UriBuilder.fromPath((String)"/group").path("{id}"));
    public static final HalRelation REL_USER = HalRelation.build("user", UserRestService.class, UriBuilder.fromPath((String)"/user").path("{id}"));
    public static final HalRelation REL_TASK = HalRelation.build("task", TaskRestService.class, UriBuilder.fromPath((String)"/task").path("{id}"));
    protected String type;
    protected String userId;
    protected String groupId;
    protected String taskId;

    public static HalIdentityLink fromIdentityLink(IdentityLink identityLink) {
        HalIdentityLink halIdentityLink = new HalIdentityLink();
        halIdentityLink.type = identityLink.getType();
        halIdentityLink.userId = identityLink.getUserId();
        halIdentityLink.groupId = identityLink.getGroupId();
        halIdentityLink.taskId = identityLink.getTaskId();
        halIdentityLink.linker.createLink(REL_USER, identityLink.getUserId());
        halIdentityLink.linker.createLink(REL_GROUP, identityLink.getGroupId());
        halIdentityLink.linker.createLink(REL_TASK, identityLink.getTaskId());
        return halIdentityLink;
    }

    public String getType() {
        return this.type;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getTaskId() {
        return this.taskId;
    }
}

