/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.rest.exception.InvalidRequestException;
import io.orqueio.bpm.engine.rest.util.EngineUtil;
import jakarta.ws.rs.core.Response;

public abstract class AbstractRestProcessEngineAware {
    private ProcessEngine processEngine;
    protected ObjectMapper objectMapper;
    protected String relativeRootResourcePath = "/";

    public AbstractRestProcessEngineAware(String engineName, ObjectMapper objectMapper) {
        this.processEngine = EngineUtil.lookupProcessEngine(engineName);
        this.objectMapper = objectMapper;
    }

    public void setRelativeRootResourceUri(String relativeRootResourcePath) {
        this.relativeRootResourcePath = relativeRootResourcePath;
    }

    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected ProcessEngine getProcessEngine() {
        if (this.processEngine == null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "No process engine available");
        }
        return this.processEngine;
    }
}

