/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.repository.CaseDefinition;
import io.orqueio.bpm.engine.repository.CaseDefinitionQuery;
import io.orqueio.bpm.engine.rest.CaseDefinitionRestService;
import io.orqueio.bpm.engine.rest.dto.CountResultDto;
import io.orqueio.bpm.engine.rest.dto.repository.CaseDefinitionDto;
import io.orqueio.bpm.engine.rest.dto.repository.CaseDefinitionQueryDto;
import io.orqueio.bpm.engine.rest.exception.RestException;
import io.orqueio.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import io.orqueio.bpm.engine.rest.sub.repository.CaseDefinitionResource;
import io.orqueio.bpm.engine.rest.sub.repository.impl.CaseDefinitionResourceImpl;
import io.orqueio.bpm.engine.rest.util.QueryUtil;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.List;

public class CaseDefinitionRestServiceImpl
extends AbstractRestProcessEngineAware
implements CaseDefinitionRestService {
    public CaseDefinitionRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public CaseDefinitionResource getCaseDefinitionByKey(String caseDefinitionKey) {
        CaseDefinition caseDefinition = (CaseDefinition)this.getProcessEngine().getRepositoryService().createCaseDefinitionQuery().caseDefinitionKey(caseDefinitionKey).withoutTenantId().latestVersion().singleResult();
        if (caseDefinition == null) {
            String errorMessage = String.format("No matching case definition with key: %s and no tenant-id", caseDefinitionKey);
            throw new RestException(Response.Status.NOT_FOUND, errorMessage);
        }
        return this.getCaseDefinitionById(caseDefinition.getId());
    }

    @Override
    public CaseDefinitionResource getCaseDefinitionByKeyAndTenantId(String caseDefinitionKey, String tenantId) {
        CaseDefinition caseDefinition = (CaseDefinition)this.getProcessEngine().getRepositoryService().createCaseDefinitionQuery().caseDefinitionKey(caseDefinitionKey).tenantIdIn(new String[]{tenantId}).latestVersion().singleResult();
        if (caseDefinition == null) {
            String errorMessage = String.format("No matching case definition with key: %s and tenant-id: %s", caseDefinitionKey, tenantId);
            throw new RestException(Response.Status.NOT_FOUND, errorMessage);
        }
        return this.getCaseDefinitionById(caseDefinition.getId());
    }

    @Override
    public CaseDefinitionResource getCaseDefinitionById(String caseDefinitionId) {
        return new CaseDefinitionResourceImpl(this.getProcessEngine(), caseDefinitionId, this.relativeRootResourcePath, this.getObjectMapper());
    }

    @Override
    public List<CaseDefinitionDto> getCaseDefinitions(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        CaseDefinitionQueryDto queryDto = new CaseDefinitionQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        ArrayList<CaseDefinitionDto> definitions = new ArrayList<CaseDefinitionDto>();
        ProcessEngine engine = this.getProcessEngine();
        CaseDefinitionQuery query = (CaseDefinitionQuery)queryDto.toQuery(engine);
        List<CaseDefinition> matchingDefinitions = QueryUtil.list(query, firstResult, maxResults);
        for (CaseDefinition definition : matchingDefinitions) {
            CaseDefinitionDto def = CaseDefinitionDto.fromCaseDefinition(definition);
            definitions.add(def);
        }
        return definitions;
    }

    @Override
    public CountResultDto getCaseDefinitionsCount(UriInfo uriInfo) {
        CaseDefinitionQueryDto queryDto = new CaseDefinitionQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        ProcessEngine engine = this.getProcessEngine();
        CaseDefinitionQuery query = (CaseDefinitionQuery)queryDto.toQuery(engine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

