/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.repository.DecisionDefinition;
import io.orqueio.bpm.engine.repository.DecisionDefinitionQuery;
import io.orqueio.bpm.engine.rest.DecisionDefinitionRestService;
import io.orqueio.bpm.engine.rest.dto.CountResultDto;
import io.orqueio.bpm.engine.rest.dto.repository.DecisionDefinitionDto;
import io.orqueio.bpm.engine.rest.dto.repository.DecisionDefinitionQueryDto;
import io.orqueio.bpm.engine.rest.exception.RestException;
import io.orqueio.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import io.orqueio.bpm.engine.rest.sub.repository.DecisionDefinitionResource;
import io.orqueio.bpm.engine.rest.sub.repository.impl.DecisionDefinitionResourceImpl;
import io.orqueio.bpm.engine.rest.util.QueryUtil;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.List;

public class DecisionDefinitionRestServiceImpl
extends AbstractRestProcessEngineAware
implements DecisionDefinitionRestService {
    public DecisionDefinitionRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public DecisionDefinitionResource getDecisionDefinitionByKey(String decisionDefinitionKey) {
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.getProcessEngine().getRepositoryService().createDecisionDefinitionQuery().decisionDefinitionKey(decisionDefinitionKey).withoutTenantId().latestVersion().singleResult();
        if (decisionDefinition == null) {
            String errorMessage = String.format("No matching decision definition with key: %s and no tenant-id", decisionDefinitionKey);
            throw new RestException(Response.Status.NOT_FOUND, errorMessage);
        }
        return this.getDecisionDefinitionById(decisionDefinition.getId());
    }

    @Override
    public DecisionDefinitionResource getDecisionDefinitionByKeyAndTenantId(String decisionDefinitionKey, String tenantId) {
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.getProcessEngine().getRepositoryService().createDecisionDefinitionQuery().decisionDefinitionKey(decisionDefinitionKey).tenantIdIn(new String[]{tenantId}).latestVersion().singleResult();
        if (decisionDefinition == null) {
            String errorMessage = String.format("No matching decision definition with key: %s and tenant-id: %s", decisionDefinitionKey, tenantId);
            throw new RestException(Response.Status.NOT_FOUND, errorMessage);
        }
        return this.getDecisionDefinitionById(decisionDefinition.getId());
    }

    @Override
    public DecisionDefinitionResource getDecisionDefinitionById(String decisionDefinitionId) {
        return new DecisionDefinitionResourceImpl(this.getProcessEngine(), decisionDefinitionId, this.relativeRootResourcePath, this.getObjectMapper());
    }

    @Override
    public List<DecisionDefinitionDto> getDecisionDefinitions(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        DecisionDefinitionQueryDto queryDto = new DecisionDefinitionQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        ArrayList<DecisionDefinitionDto> definitions = new ArrayList<DecisionDefinitionDto>();
        ProcessEngine engine = this.getProcessEngine();
        DecisionDefinitionQuery query = (DecisionDefinitionQuery)queryDto.toQuery(engine);
        List<DecisionDefinition> matchingDefinitions = QueryUtil.list(query, firstResult, maxResults);
        for (DecisionDefinition definition : matchingDefinitions) {
            DecisionDefinitionDto def = DecisionDefinitionDto.fromDecisionDefinition(definition);
            definitions.add(def);
        }
        return definitions;
    }

    @Override
    public CountResultDto getDecisionDefinitionsCount(UriInfo uriInfo) {
        DecisionDefinitionQueryDto queryDto = new DecisionDefinitionQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        ProcessEngine engine = this.getProcessEngine();
        DecisionDefinitionQuery query = (DecisionDefinitionQuery)queryDto.toQuery(engine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

