/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.rest.EventSubscriptionRestService;
import io.orqueio.bpm.engine.rest.dto.CountResultDto;
import io.orqueio.bpm.engine.rest.dto.runtime.EventSubscriptionDto;
import io.orqueio.bpm.engine.rest.dto.runtime.EventSubscriptionQueryDto;
import io.orqueio.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import io.orqueio.bpm.engine.rest.util.QueryUtil;
import io.orqueio.bpm.engine.runtime.EventSubscription;
import io.orqueio.bpm.engine.runtime.EventSubscriptionQuery;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.List;

public class EventSubscriptionRestServiceImpl
extends AbstractRestProcessEngineAware
implements EventSubscriptionRestService {
    public EventSubscriptionRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public List<EventSubscriptionDto> getEventSubscriptions(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        EventSubscriptionQueryDto queryDto = new EventSubscriptionQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryEventSubscriptions(queryDto, firstResult, maxResults);
    }

    public List<EventSubscriptionDto> queryEventSubscriptions(EventSubscriptionQueryDto queryDto, Integer firstResult, Integer maxResults) {
        ProcessEngine engine = this.getProcessEngine();
        queryDto.setObjectMapper(this.getObjectMapper());
        EventSubscriptionQuery query = (EventSubscriptionQuery)queryDto.toQuery(engine);
        List<EventSubscription> matchingEventSubscriptions = QueryUtil.list(query, firstResult, maxResults);
        ArrayList<EventSubscriptionDto> eventSubscriptionResults = new ArrayList<EventSubscriptionDto>();
        for (EventSubscription eventSubscription : matchingEventSubscriptions) {
            EventSubscriptionDto resultEventSubscription = EventSubscriptionDto.fromEventSubscription(eventSubscription);
            eventSubscriptionResults.add(resultEventSubscription);
        }
        return eventSubscriptionResults;
    }

    @Override
    public CountResultDto getEventSubscriptionsCount(UriInfo uriInfo) {
        EventSubscriptionQueryDto queryDto = new EventSubscriptionQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryEventSubscriptionsCount(queryDto);
    }

    public CountResultDto queryEventSubscriptionsCount(EventSubscriptionQueryDto queryDto) {
        ProcessEngine engine = this.getProcessEngine();
        queryDto.setObjectMapper(this.getObjectMapper());
        EventSubscriptionQuery query = (EventSubscriptionQuery)queryDto.toQuery(engine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

