/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.rest.IncidentRestService;
import io.orqueio.bpm.engine.rest.dto.CountResultDto;
import io.orqueio.bpm.engine.rest.dto.runtime.IncidentDto;
import io.orqueio.bpm.engine.rest.dto.runtime.IncidentQueryDto;
import io.orqueio.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import io.orqueio.bpm.engine.rest.sub.repository.impl.IncidentResourceImpl;
import io.orqueio.bpm.engine.rest.sub.runtime.IncidentResource;
import io.orqueio.bpm.engine.rest.util.QueryUtil;
import io.orqueio.bpm.engine.runtime.Incident;
import io.orqueio.bpm.engine.runtime.IncidentQuery;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.List;

public class IncidentRestServiceImpl
extends AbstractRestProcessEngineAware
implements IncidentRestService {
    public IncidentRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public List<IncidentDto> getIncidents(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        IncidentQueryDto queryDto = new IncidentQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        IncidentQuery query = (IncidentQuery)queryDto.toQuery(this.getProcessEngine());
        List<Incident> queryResult = QueryUtil.list(query, firstResult, maxResults);
        ArrayList<IncidentDto> result = new ArrayList<IncidentDto>();
        for (Incident incident : queryResult) {
            IncidentDto dto = IncidentDto.fromIncident(incident);
            result.add(dto);
        }
        return result;
    }

    @Override
    public CountResultDto getIncidentsCount(UriInfo uriInfo) {
        IncidentQueryDto queryDto = new IncidentQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        IncidentQuery query = (IncidentQuery)queryDto.toQuery(this.getProcessEngine());
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }

    @Override
    public IncidentResource getIncident(String incidentId) {
        return new IncidentResourceImpl(this.getProcessEngine(), incidentId, this.getObjectMapper());
    }
}

