/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.RuntimeService;
import io.orqueio.bpm.engine.exception.NotFoundException;
import io.orqueio.bpm.engine.rest.SignalRestService;
import io.orqueio.bpm.engine.rest.dto.SignalDto;
import io.orqueio.bpm.engine.rest.dto.VariableValueDto;
import io.orqueio.bpm.engine.rest.exception.InvalidRequestException;
import io.orqueio.bpm.engine.rest.exception.RestException;
import io.orqueio.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import io.orqueio.bpm.engine.runtime.SignalEventReceivedBuilder;
import io.orqueio.bpm.engine.variable.VariableMap;
import jakarta.ws.rs.core.Response;
import java.util.Map;

public class SignalRestServiceImpl
extends AbstractRestProcessEngineAware
implements SignalRestService {
    public SignalRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public void throwSignal(SignalDto dto) {
        String name = dto.getName();
        if (name == null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "No signal name given");
        }
        SignalEventReceivedBuilder signalEvent = this.createSignalEventReceivedBuilder(dto);
        try {
            signalEvent.send();
        }
        catch (NotFoundException e) {
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), e.getMessage());
        }
    }

    protected SignalEventReceivedBuilder createSignalEventReceivedBuilder(SignalDto dto) {
        boolean isWithoutTenantId;
        String tenantId;
        Map<String, VariableValueDto> variablesDto;
        RuntimeService runtimeService = this.getProcessEngine().getRuntimeService();
        String name = dto.getName();
        SignalEventReceivedBuilder signalEvent = runtimeService.createSignalEvent(name);
        String executionId = dto.getExecutionId();
        if (executionId != null) {
            signalEvent.executionId(executionId);
        }
        if ((variablesDto = dto.getVariables()) != null) {
            VariableMap variables = VariableValueDto.toMap(variablesDto, this.getProcessEngine(), this.objectMapper);
            signalEvent.setVariables((Map)variables);
        }
        if ((tenantId = dto.getTenantId()) != null) {
            signalEvent.tenantId(tenantId);
        }
        if (isWithoutTenantId = dto.isWithoutTenantId()) {
            signalEvent.withoutTenantId();
        }
        return signalEvent;
    }
}

