/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.history.HistoricCaseActivityInstance;
import io.orqueio.bpm.engine.history.HistoricCaseActivityInstanceQuery;
import io.orqueio.bpm.engine.rest.dto.CountResultDto;
import io.orqueio.bpm.engine.rest.dto.history.HistoricCaseActivityInstanceDto;
import io.orqueio.bpm.engine.rest.dto.history.HistoricCaseActivityInstanceQueryDto;
import io.orqueio.bpm.engine.rest.history.HistoricCaseActivityInstanceRestService;
import io.orqueio.bpm.engine.rest.sub.history.HistoricCaseActivityInstanceResource;
import io.orqueio.bpm.engine.rest.sub.history.impl.HistoricCaseActivityInstanceResourceImpl;
import io.orqueio.bpm.engine.rest.util.QueryUtil;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.List;

public class HistoricCaseActivityInstanceRestServiceImpl
implements HistoricCaseActivityInstanceRestService {
    protected ProcessEngine processEngine;
    protected ObjectMapper objectMapper;

    public HistoricCaseActivityInstanceRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    @Override
    public HistoricCaseActivityInstanceResource getHistoricCaseInstance(String caseActivityInstanceId) {
        return new HistoricCaseActivityInstanceResourceImpl(this.processEngine, caseActivityInstanceId);
    }

    @Override
    public List<HistoricCaseActivityInstanceDto> getHistoricCaseActivityInstances(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        HistoricCaseActivityInstanceQueryDto queryHistoricCaseActivityInstanceDto = new HistoricCaseActivityInstanceQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryHistoricCaseActivityInstances(queryHistoricCaseActivityInstanceDto, firstResult, maxResults);
    }

    public List<HistoricCaseActivityInstanceDto> queryHistoricCaseActivityInstances(HistoricCaseActivityInstanceQueryDto queryDto, Integer firstResult, Integer maxResults) {
        HistoricCaseActivityInstanceQuery query = (HistoricCaseActivityInstanceQuery)queryDto.toQuery(this.processEngine);
        List<HistoricCaseActivityInstance> matchingHistoricCaseActivityInstances = QueryUtil.list(query, firstResult, maxResults);
        ArrayList<HistoricCaseActivityInstanceDto> historicCaseActivityInstanceResults = new ArrayList<HistoricCaseActivityInstanceDto>();
        for (HistoricCaseActivityInstance historicCaseActivityInstance : matchingHistoricCaseActivityInstances) {
            HistoricCaseActivityInstanceDto resultHistoricCaseActivityInstance = HistoricCaseActivityInstanceDto.fromHistoricCaseActivityInstance(historicCaseActivityInstance);
            historicCaseActivityInstanceResults.add(resultHistoricCaseActivityInstance);
        }
        return historicCaseActivityInstanceResults;
    }

    @Override
    public CountResultDto getHistoricCaseActivityInstancesCount(UriInfo uriInfo) {
        HistoricCaseActivityInstanceQueryDto queryDto = new HistoricCaseActivityInstanceQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryHistoricCaseActivityInstancesCount(queryDto);
    }

    public CountResultDto queryHistoricCaseActivityInstancesCount(HistoricCaseActivityInstanceQueryDto queryDto) {
        HistoricCaseActivityInstanceQuery query = (HistoricCaseActivityInstanceQuery)queryDto.toQuery(this.processEngine);
        long count = query.count();
        return new CountResultDto(count);
    }
}

