/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.history.HistoricVariableInstance;
import io.orqueio.bpm.engine.history.HistoricVariableInstanceQuery;
import io.orqueio.bpm.engine.rest.dto.CountResultDto;
import io.orqueio.bpm.engine.rest.dto.history.HistoricVariableInstanceDto;
import io.orqueio.bpm.engine.rest.dto.history.HistoricVariableInstanceQueryDto;
import io.orqueio.bpm.engine.rest.history.HistoricVariableInstanceRestService;
import io.orqueio.bpm.engine.rest.sub.history.HistoricVariableInstanceResource;
import io.orqueio.bpm.engine.rest.sub.history.impl.HistoricVariableInstanceResourceImpl;
import io.orqueio.bpm.engine.rest.util.QueryUtil;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.List;

public class HistoricVariableInstanceRestServiceImpl
implements HistoricVariableInstanceRestService {
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public HistoricVariableInstanceRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    @Override
    public HistoricVariableInstanceResource variableInstanceResource(String variableId) {
        return new HistoricVariableInstanceResourceImpl(variableId, this.processEngine);
    }

    @Override
    public List<HistoricVariableInstanceDto> getHistoricVariableInstances(UriInfo uriInfo, Integer firstResult, Integer maxResults, boolean deserializeObjectValues) {
        HistoricVariableInstanceQueryDto queryDto = new HistoricVariableInstanceQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryHistoricVariableInstances(queryDto, firstResult, maxResults, deserializeObjectValues);
    }

    @Override
    public List<HistoricVariableInstanceDto> queryHistoricVariableInstances(HistoricVariableInstanceQueryDto queryDto, Integer firstResult, Integer maxResults, boolean deserializeObjectValues) {
        queryDto.setObjectMapper(this.objectMapper);
        HistoricVariableInstanceQuery query = (HistoricVariableInstanceQuery)queryDto.toQuery(this.processEngine);
        query.disableBinaryFetching();
        if (!deserializeObjectValues) {
            query.disableCustomObjectDeserialization();
        }
        List<HistoricVariableInstance> matchingHistoricVariableInstances = QueryUtil.list(query, firstResult, maxResults);
        ArrayList<HistoricVariableInstanceDto> historicVariableInstanceDtoResults = new ArrayList<HistoricVariableInstanceDto>();
        for (HistoricVariableInstance historicVariableInstance : matchingHistoricVariableInstances) {
            HistoricVariableInstanceDto resultHistoricVariableInstance = HistoricVariableInstanceDto.fromHistoricVariableInstance(historicVariableInstance);
            historicVariableInstanceDtoResults.add(resultHistoricVariableInstance);
        }
        return historicVariableInstanceDtoResults;
    }

    @Override
    public CountResultDto getHistoricVariableInstancesCount(UriInfo uriInfo) {
        HistoricVariableInstanceQueryDto queryDto = new HistoricVariableInstanceQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryHistoricVariableInstancesCount(queryDto);
    }

    @Override
    public CountResultDto queryHistoricVariableInstancesCount(HistoricVariableInstanceQueryDto queryDto) {
        queryDto.setObjectMapper(this.objectMapper);
        HistoricVariableInstanceQuery query = (HistoricVariableInstanceQuery)queryDto.toQuery(this.processEngine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

