/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.history.UserOperationLogQuery;
import io.orqueio.bpm.engine.rest.dto.AnnotationDto;
import io.orqueio.bpm.engine.rest.dto.CountResultDto;
import io.orqueio.bpm.engine.rest.dto.history.UserOperationLogEntryDto;
import io.orqueio.bpm.engine.rest.dto.history.UserOperationLogQueryDto;
import io.orqueio.bpm.engine.rest.history.UserOperationLogRestService;
import io.orqueio.bpm.engine.rest.util.QueryUtil;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;

public class UserOperationLogRestServiceImpl
implements UserOperationLogRestService {
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public UserOperationLogRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    @Override
    public CountResultDto queryUserOperationCount(UriInfo uriInfo) {
        UserOperationLogQueryDto queryDto = new UserOperationLogQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        UserOperationLogQuery query = (UserOperationLogQuery)queryDto.toQuery(this.processEngine);
        return new CountResultDto(query.count());
    }

    @Override
    public List<UserOperationLogEntryDto> queryUserOperationEntries(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        UserOperationLogQueryDto queryDto = new UserOperationLogQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        UserOperationLogQuery query = (UserOperationLogQuery)queryDto.toQuery(this.processEngine);
        return UserOperationLogEntryDto.map(QueryUtil.list(query, firstResult, maxResults));
    }

    @Override
    public Response setAnnotation(String operationId, AnnotationDto annotationDto) {
        String annotation = annotationDto.getAnnotation();
        this.processEngine.getHistoryService().setAnnotationForOperationLogById(operationId, annotation);
        return Response.noContent().build();
    }

    @Override
    public Response clearAnnotation(String operationId) {
        this.processEngine.getHistoryService().clearAnnotationForOperationLogById(operationId);
        return Response.noContent().build();
    }
}

