/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.sub.history.impl;

import io.orqueio.bpm.engine.AuthorizationException;
import io.orqueio.bpm.engine.HistoryService;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.ProcessEngineException;
import io.orqueio.bpm.engine.history.HistoricExternalTaskLog;
import io.orqueio.bpm.engine.rest.dto.history.HistoricExternalTaskLogDto;
import io.orqueio.bpm.engine.rest.exception.InvalidRequestException;
import io.orqueio.bpm.engine.rest.sub.history.HistoricExternalTaskLogResource;
import jakarta.ws.rs.core.Response;

public class HistoricExternalTaskLogResourceImpl
implements HistoricExternalTaskLogResource {
    protected String id;
    protected ProcessEngine engine;

    public HistoricExternalTaskLogResourceImpl(String id, ProcessEngine engine) {
        this.id = id;
        this.engine = engine;
    }

    @Override
    public HistoricExternalTaskLogDto getHistoricExternalTaskLog() {
        HistoryService historyService = this.engine.getHistoryService();
        HistoricExternalTaskLog historicExternalTaskLog = (HistoricExternalTaskLog)historyService.createHistoricExternalTaskLogQuery().logId(this.id).singleResult();
        if (historicExternalTaskLog == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Historic external task log with id " + this.id + " does not exist");
        }
        return HistoricExternalTaskLogDto.fromHistoricExternalTaskLog(historicExternalTaskLog);
    }

    @Override
    public String getErrorDetails() {
        try {
            HistoryService historyService = this.engine.getHistoryService();
            return historyService.getHistoricExternalTaskLogErrorDetails(this.id);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, e.getMessage());
        }
    }
}

