/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.sub.history.impl;

import io.orqueio.bpm.engine.AuthorizationException;
import io.orqueio.bpm.engine.HistoryService;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.ProcessEngineException;
import io.orqueio.bpm.engine.history.HistoricProcessInstance;
import io.orqueio.bpm.engine.rest.dto.history.HistoricProcessInstanceDto;
import io.orqueio.bpm.engine.rest.exception.InvalidRequestException;
import io.orqueio.bpm.engine.rest.sub.history.HistoricProcessInstanceResource;
import jakarta.ws.rs.core.Response;

public class HistoricProcessInstanceResourceImpl
implements HistoricProcessInstanceResource {
    private ProcessEngine engine;
    private String processInstanceId;

    public HistoricProcessInstanceResourceImpl(ProcessEngine engine, String processInstanceId) {
        this.engine = engine;
        this.processInstanceId = processInstanceId;
    }

    @Override
    public HistoricProcessInstanceDto getHistoricProcessInstance() {
        HistoryService historyService = this.engine.getHistoryService();
        HistoricProcessInstance instance = (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(this.processInstanceId).singleResult();
        if (instance == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Historic process instance with id " + this.processInstanceId + " does not exist");
        }
        return HistoricProcessInstanceDto.fromHistoricProcessInstance(instance);
    }

    @Override
    public void deleteHistoricProcessInstance(Boolean failIfNotExists) {
        HistoryService historyService = this.engine.getHistoryService();
        try {
            if (failIfNotExists == null || failIfNotExists.booleanValue()) {
                historyService.deleteHistoricProcessInstance(this.processInstanceId);
            } else {
                historyService.deleteHistoricProcessInstanceIfExists(this.processInstanceId);
            }
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, (Exception)((Object)e), "Historic process instance with id " + this.processInstanceId + " does not exist");
        }
    }
}

