/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.sub.identity.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.ProcessEngineException;
import io.orqueio.bpm.engine.authorization.Permission;
import io.orqueio.bpm.engine.authorization.Permissions;
import io.orqueio.bpm.engine.authorization.Resource;
import io.orqueio.bpm.engine.authorization.Resources;
import io.orqueio.bpm.engine.identity.User;
import io.orqueio.bpm.engine.impl.identity.Authentication;
import io.orqueio.bpm.engine.rest.dto.ResourceOptionsDto;
import io.orqueio.bpm.engine.rest.dto.identity.UserCredentialsDto;
import io.orqueio.bpm.engine.rest.dto.identity.UserProfileDto;
import io.orqueio.bpm.engine.rest.exception.InvalidRequestException;
import io.orqueio.bpm.engine.rest.sub.identity.UserResource;
import io.orqueio.bpm.engine.rest.sub.identity.impl.AbstractIdentityResource;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;

public class UserResourceImpl
extends AbstractIdentityResource
implements UserResource {
    protected String rootResourcePath;

    public UserResourceImpl(String processEngineName, String userId, String rootResourcePath, ObjectMapper objectMapper) {
        super(processEngineName, (Resource)Resources.USER, userId, objectMapper);
        this.rootResourcePath = rootResourcePath;
    }

    @Override
    public UserProfileDto getUserProfile(UriInfo context) {
        User dbUser = this.findUserObject();
        if (dbUser == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "User with id " + this.resourceId + " does not exist");
        }
        UserProfileDto user = UserProfileDto.fromUser(dbUser);
        return user;
    }

    @Override
    public ResourceOptionsDto availableOperations(UriInfo context) {
        ResourceOptionsDto dto = new ResourceOptionsDto();
        UriBuilder baseUriBuilder = context.getBaseUriBuilder().path(this.rootResourcePath).path("/user").path(this.resourceId);
        URI baseUri = baseUriBuilder.build(new Object[0]);
        URI profileUri = baseUriBuilder.path("/profile").build(new Object[0]);
        dto.addReflexiveLink(profileUri, "GET", "self");
        if (!this.identityService.isReadOnly() && this.isAuthorized((Permission)Permissions.DELETE)) {
            dto.addReflexiveLink(baseUri, "DELETE", "delete");
        }
        if (!this.identityService.isReadOnly() && this.isAuthorized((Permission)Permissions.UPDATE)) {
            dto.addReflexiveLink(profileUri, "PUT", "update");
        }
        return dto;
    }

    @Override
    public void deleteUser() {
        this.ensureNotReadOnly();
        this.identityService.deleteUser(this.resourceId);
    }

    @Override
    public void unlockUser() {
        this.ensureNotReadOnly();
        this.identityService.unlockUser(this.resourceId);
    }

    @Override
    public void updateCredentials(UserCredentialsDto account) {
        this.ensureNotReadOnly();
        Authentication currentAuthentication = this.identityService.getCurrentAuthentication();
        if (currentAuthentication != null && currentAuthentication.getUserId() != null && !this.identityService.checkPassword(currentAuthentication.getUserId(), account.getAuthenticatedUserPassword())) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "The given authenticated user password is not valid.");
        }
        User dbUser = this.findUserObject();
        if (dbUser == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "User with id " + this.resourceId + " does not exist");
        }
        dbUser.setPassword(account.getPassword());
        this.identityService.saveUser(dbUser);
    }

    @Override
    public void updateProfile(UserProfileDto profile) {
        this.ensureNotReadOnly();
        User dbUser = this.findUserObject();
        if (dbUser == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "User with id " + this.resourceId + " does not exist");
        }
        profile.update(dbUser);
        this.identityService.saveUser(dbUser);
    }

    protected User findUserObject() {
        try {
            return (User)this.identityService.createUserQuery().userId(this.resourceId).singleResult();
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.INTERNAL_SERVER_ERROR, "Exception while performing user query: " + e.getMessage());
        }
    }
}

