/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.sub.management;

import io.orqueio.bpm.engine.AuthorizationException;
import io.orqueio.bpm.engine.ManagementService;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.ProcessEngineException;
import io.orqueio.bpm.engine.exception.NotFoundException;
import io.orqueio.bpm.engine.management.JobDefinition;
import io.orqueio.bpm.engine.management.SetJobRetriesBuilder;
import io.orqueio.bpm.engine.rest.dto.management.JobDefinitionDto;
import io.orqueio.bpm.engine.rest.dto.management.JobDefinitionSuspensionStateDto;
import io.orqueio.bpm.engine.rest.dto.runtime.JobDefinitionPriorityDto;
import io.orqueio.bpm.engine.rest.dto.runtime.RetriesDto;
import io.orqueio.bpm.engine.rest.exception.InvalidRequestException;
import io.orqueio.bpm.engine.rest.exception.RestException;
import io.orqueio.bpm.engine.rest.sub.management.JobDefinitionResource;
import jakarta.ws.rs.core.Response;

public class JobDefinitionResourceImpl
implements JobDefinitionResource {
    protected ProcessEngine engine;
    protected String jobDefinitionId;

    public JobDefinitionResourceImpl(ProcessEngine engine, String jobDefinitionId) {
        this.engine = engine;
        this.jobDefinitionId = jobDefinitionId;
    }

    @Override
    public JobDefinitionDto getJobDefinition() {
        ManagementService managementService = this.engine.getManagementService();
        JobDefinition jobDefinition = (JobDefinition)managementService.createJobDefinitionQuery().jobDefinitionId(this.jobDefinitionId).singleResult();
        if (jobDefinition == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Job Definition with id " + this.jobDefinitionId + " does not exist");
        }
        return JobDefinitionDto.fromJobDefinition(jobDefinition);
    }

    @Override
    public void updateSuspensionState(JobDefinitionSuspensionStateDto dto) {
        try {
            dto.setJobDefinitionId(this.jobDefinitionId);
            dto.updateSuspensionState(this.engine);
        }
        catch (IllegalArgumentException e) {
            String message = String.format("The suspension state of Job Definition with id %s could not be updated due to: %s", this.jobDefinitionId, e.getMessage());
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e, message);
        }
    }

    @Override
    public void setJobRetries(RetriesDto dto) {
        try {
            SetJobRetriesBuilder builder = this.engine.getManagementService().setJobRetries(dto.getRetries().intValue()).jobDefinitionId(this.jobDefinitionId);
            if (dto.isDueDateSet()) {
                builder.dueDate(dto.getDueDate());
            }
            builder.execute();
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    @Override
    public void setJobPriority(JobDefinitionPriorityDto dto) {
        try {
            ManagementService managementService = this.engine.getManagementService();
            if (dto.getPriority() != null) {
                managementService.setOverridingJobPriorityForJobDefinition(this.jobDefinitionId, dto.getPriority().longValue(), dto.isIncludeJobs());
            } else {
                if (dto.isIncludeJobs()) {
                    throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Cannot reset priority for job definition " + this.jobDefinitionId + " with includeJobs=true");
                }
                managementService.clearOverridingJobPriorityForJobDefinition(this.jobDefinitionId);
            }
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (NotFoundException e) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, e.getMessage());
        }
        catch (ProcessEngineException e) {
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }
}

