/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.sub.runtime.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.AuthorizationException;
import io.orqueio.bpm.engine.BadUserRequestException;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.ProcessEngineException;
import io.orqueio.bpm.engine.RuntimeService;
import io.orqueio.bpm.engine.rest.dto.CreateIncidentDto;
import io.orqueio.bpm.engine.rest.dto.VariableValueDto;
import io.orqueio.bpm.engine.rest.dto.runtime.ExecutionDto;
import io.orqueio.bpm.engine.rest.dto.runtime.ExecutionTriggerDto;
import io.orqueio.bpm.engine.rest.dto.runtime.IncidentDto;
import io.orqueio.bpm.engine.rest.exception.InvalidRequestException;
import io.orqueio.bpm.engine.rest.exception.RestException;
import io.orqueio.bpm.engine.rest.sub.VariableResource;
import io.orqueio.bpm.engine.rest.sub.runtime.EventSubscriptionResource;
import io.orqueio.bpm.engine.rest.sub.runtime.ExecutionResource;
import io.orqueio.bpm.engine.rest.sub.runtime.impl.LocalExecutionVariablesResource;
import io.orqueio.bpm.engine.rest.sub.runtime.impl.MessageEventSubscriptionResource;
import io.orqueio.bpm.engine.runtime.Execution;
import io.orqueio.bpm.engine.runtime.Incident;
import io.orqueio.bpm.engine.variable.VariableMap;
import jakarta.ws.rs.core.Response;
import java.util.Map;

public class ExecutionResourceImpl
implements ExecutionResource {
    protected ProcessEngine engine;
    protected String executionId;
    protected ObjectMapper objectMapper;

    public ExecutionResourceImpl(ProcessEngine engine, String executionId, ObjectMapper objectMapper) {
        this.engine = engine;
        this.executionId = executionId;
        this.objectMapper = objectMapper;
    }

    @Override
    public ExecutionDto getExecution() {
        RuntimeService runtimeService = this.engine.getRuntimeService();
        Execution execution = (Execution)runtimeService.createExecutionQuery().executionId(this.executionId).singleResult();
        if (execution == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Execution with id " + this.executionId + " does not exist");
        }
        return ExecutionDto.fromExecution(execution);
    }

    @Override
    public void signalExecution(ExecutionTriggerDto triggerDto) {
        RuntimeService runtimeService = this.engine.getRuntimeService();
        try {
            VariableMap variables = VariableValueDto.toMap(triggerDto.getVariables(), this.engine, this.objectMapper);
            runtimeService.signal(this.executionId, (Map)variables);
        }
        catch (RestException e) {
            String errorMessage = String.format("Cannot signal execution %s: %s", this.executionId, e.getMessage());
            throw new InvalidRequestException(e.getStatus(), e, errorMessage);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, (Exception)((Object)e), "Cannot signal execution " + this.executionId + ": " + e.getMessage());
        }
    }

    @Override
    public VariableResource getLocalVariables() {
        return new LocalExecutionVariablesResource(this.engine, this.executionId, this.objectMapper);
    }

    @Override
    public EventSubscriptionResource getMessageEventSubscription(String messageName) {
        return new MessageEventSubscriptionResource(this.engine, this.executionId, messageName, this.objectMapper);
    }

    @Override
    public IncidentDto createIncident(CreateIncidentDto createIncidentDto) {
        Incident newIncident = null;
        try {
            newIncident = this.engine.getRuntimeService().createIncident(createIncidentDto.getIncidentType(), this.executionId, createIncidentDto.getConfiguration(), createIncidentDto.getMessage());
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        return IncidentDto.fromIncident(newIncident);
    }
}

