/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.sub.task.impl;

import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.rest.dto.converter.TaskReportResultToCsvConverter;
import io.orqueio.bpm.engine.rest.dto.task.TaskCountByCandidateGroupResultDto;
import io.orqueio.bpm.engine.rest.exception.InvalidRequestException;
import io.orqueio.bpm.engine.rest.sub.task.TaskReportResource;
import io.orqueio.bpm.engine.rest.util.URLEncodingUtil;
import io.orqueio.bpm.engine.task.TaskCountByCandidateGroupResult;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.Variant;
import java.util.ArrayList;
import java.util.List;

public class TaskReportResourceImpl
implements TaskReportResource {
    public static final MediaType APPLICATION_CSV_TYPE = new MediaType("application", "csv");
    public static final MediaType TEXT_CSV_TYPE = new MediaType("text", "csv");
    public static final List<Variant> VARIANTS = Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON_TYPE, APPLICATION_CSV_TYPE, TEXT_CSV_TYPE}).add().build();
    protected ProcessEngine engine;

    public TaskReportResourceImpl(ProcessEngine engine) {
        this.engine = engine;
    }

    @Override
    public Response getTaskCountByCandidateGroupReport(Request request) {
        Variant variant = request.selectVariant(VARIANTS);
        if (variant != null) {
            MediaType mediaType = variant.getMediaType();
            if (MediaType.APPLICATION_JSON_TYPE.equals((Object)mediaType)) {
                List<TaskCountByCandidateGroupResultDto> result = this.getTaskCountByCandidateGroupResultAsJson();
                return Response.ok(result, (MediaType)mediaType).build();
            }
            if (APPLICATION_CSV_TYPE.equals((Object)mediaType) || TEXT_CSV_TYPE.equals((Object)mediaType)) {
                String csv = this.getReportResultAsCsv();
                return Response.ok((Object)csv, (MediaType)mediaType).header("Content-Disposition", (Object)URLEncodingUtil.buildAttachmentValue("task-count-by-candidate-group.csv")).build();
            }
        }
        throw new InvalidRequestException(Response.Status.NOT_ACCEPTABLE, "No acceptable content-type found");
    }

    protected List<TaskCountByCandidateGroupResult> queryTaskCountByCandidateGroupReport() {
        TaskCountByCandidateGroupResultDto reportDto = new TaskCountByCandidateGroupResultDto();
        return reportDto.executeTaskCountByCandidateGroupReport(this.engine);
    }

    protected List<TaskCountByCandidateGroupResultDto> getTaskCountByCandidateGroupResultAsJson() {
        List<TaskCountByCandidateGroupResult> reports = this.queryTaskCountByCandidateGroupReport();
        ArrayList<TaskCountByCandidateGroupResultDto> result = new ArrayList<TaskCountByCandidateGroupResultDto>();
        for (TaskCountByCandidateGroupResult report : reports) {
            result.add(TaskCountByCandidateGroupResultDto.fromTaskCountByCandidateGroupResultDto(report));
        }
        return result;
    }

    protected String getReportResultAsCsv() {
        List<TaskCountByCandidateGroupResult> reports = this.queryTaskCountByCandidateGroupReport();
        return TaskReportResultToCsvConverter.convertCandidateGroupReportResult(reports);
    }
}

