/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.util;

import io.orqueio.bpm.BpmPlatform;
import io.orqueio.bpm.ProcessApplicationService;
import io.orqueio.bpm.application.ProcessApplicationInfo;
import io.orqueio.bpm.engine.IdentityService;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.impl.identity.Authentication;
import io.orqueio.bpm.engine.repository.CaseDefinition;
import io.orqueio.bpm.engine.repository.ProcessDefinition;

public class ApplicationContextPathUtil {
    public static String getApplicationPathByProcessDefinitionId(ProcessEngine engine, String processDefinitionId) {
        ProcessDefinition processDefinition = engine.getRepositoryService().getProcessDefinition(processDefinitionId);
        if (processDefinition == null) {
            return null;
        }
        return ApplicationContextPathUtil.getApplicationPathForDeployment(engine, processDefinition.getDeploymentId());
    }

    public static String getApplicationPathByCaseDefinitionId(ProcessEngine engine, String caseDefinitionId) {
        CaseDefinition caseDefinition = engine.getRepositoryService().getCaseDefinition(caseDefinitionId);
        if (caseDefinition == null) {
            return null;
        }
        return ApplicationContextPathUtil.getApplicationPathForDeployment(engine, caseDefinition.getDeploymentId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getApplicationPathForDeployment(ProcessEngine engine, String deploymentId) {
        String processApplicationName = null;
        IdentityService identityService = engine.getIdentityService();
        Authentication currentAuthentication = identityService.getCurrentAuthentication();
        try {
            identityService.clearAuthentication();
            processApplicationName = engine.getManagementService().getProcessApplicationForDeployment(deploymentId);
        }
        finally {
            identityService.setAuthentication(currentAuthentication);
        }
        if (processApplicationName == null) {
            return null;
        }
        ProcessApplicationService processApplicationService = BpmPlatform.getProcessApplicationService();
        ProcessApplicationInfo processApplicationInfo = processApplicationService.getProcessApplicationInfo(processApplicationName);
        return (String)processApplicationInfo.getProperties().get("servletContextPath");
    }
}

