/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.util;

import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.rest.exception.RestException;
import io.orqueio.bpm.engine.rest.spi.ProcessEngineProvider;
import jakarta.ws.rs.core.Response;
import java.util.Iterator;
import java.util.ServiceLoader;

public class EngineUtil {
    public static ProcessEngine lookupProcessEngine(String engineName) {
        ServiceLoader<ProcessEngineProvider> serviceLoader = ServiceLoader.load(ProcessEngineProvider.class);
        Iterator<ProcessEngineProvider> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            ProcessEngineProvider provider = iterator.next();
            if (engineName == null) {
                return provider.getDefaultProcessEngine();
            }
            return provider.getProcessEngine(engineName);
        }
        throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, "Could not find an implementation of the " + String.valueOf(ProcessEngineProvider.class) + "- SPI");
    }

    public static ProcessEngineProvider getProcessEngineProvider() {
        ServiceLoader<ProcessEngineProvider> serviceLoader = ServiceLoader.load(ProcessEngineProvider.class);
        Iterator<ProcessEngineProvider> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            ProcessEngineProvider provider = iterator.next();
            return provider;
        }
        throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, "No process engine provider found");
    }
}

