/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.dto.authorization;

import io.orqueio.bpm.engine.ProcessEngineConfiguration;
import io.orqueio.bpm.engine.authorization.Authorization;
import io.orqueio.bpm.engine.authorization.Permission;
import io.orqueio.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.orqueio.bpm.engine.impl.util.PermissionConverter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AuthorizationDto {
    protected String id;
    protected Integer type;
    protected String[] permissions;
    protected String userId;
    protected String groupId;
    protected Integer resourceType;
    protected String resourceId;
    protected Date removalTime;
    protected String rootProcessInstanceId;

    public static AuthorizationDto fromAuthorization(Authorization dbAuthorization, ProcessEngineConfiguration engineConfiguration) {
        AuthorizationDto authorizationDto = new AuthorizationDto();
        authorizationDto.setId(dbAuthorization.getId());
        authorizationDto.setType(dbAuthorization.getAuthorizationType());
        Permission[] dbPermissions = AuthorizationDto.getPermissions(dbAuthorization, engineConfiguration);
        authorizationDto.setPermissions(PermissionConverter.getNamesForPermissions((Authorization)dbAuthorization, (Permission[])dbPermissions));
        authorizationDto.setUserId(dbAuthorization.getUserId());
        authorizationDto.setGroupId(dbAuthorization.getGroupId());
        authorizationDto.setResourceType(dbAuthorization.getResourceType());
        authorizationDto.setResourceId(dbAuthorization.getResourceId());
        authorizationDto.setRemovalTime(dbAuthorization.getRemovalTime());
        authorizationDto.setRootProcessInstanceId(dbAuthorization.getRootProcessInstanceId());
        return authorizationDto;
    }

    public static void update(AuthorizationDto dto, Authorization dbAuthorization, ProcessEngineConfiguration engineConfiguration) {
        dbAuthorization.setGroupId(dto.getGroupId());
        dbAuthorization.setUserId(dto.getUserId());
        dbAuthorization.setResourceId(dto.getResourceId());
        if (dto.getResourceType() != null) {
            dbAuthorization.setResourceType(dto.getResourceType().intValue());
        }
        if (dto.getPermissions() != null) {
            dbAuthorization.setPermissions(PermissionConverter.getPermissionsForNames((String[])dto.getPermissions(), (int)dto.getResourceType(), (ProcessEngineConfiguration)engineConfiguration));
        }
    }

    public static List<AuthorizationDto> fromAuthorizationList(List<Authorization> resultList, ProcessEngineConfiguration engineConfiguration) {
        ArrayList<AuthorizationDto> result = new ArrayList<AuthorizationDto>();
        for (Authorization authorization : resultList) {
            result.add(AuthorizationDto.fromAuthorization(authorization, engineConfiguration));
        }
        return result;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String[] getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String[] permissions) {
        this.permissions = permissions;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public Integer getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(Integer resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getRootProcessInstanceId() {
        return this.rootProcessInstanceId;
    }

    public void setRootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
    }

    public Date getRemovalTime() {
        return this.removalTime;
    }

    public void setRemovalTime(Date removalTime) {
        this.removalTime = removalTime;
    }

    private static Permission[] getPermissions(Authorization dbAuthorization, ProcessEngineConfiguration engineConfiguration) {
        int givenResourceType = dbAuthorization.getResourceType();
        Permission[] permissionsByResourceType = ((ProcessEngineConfigurationImpl)engineConfiguration).getPermissionProvider().getPermissionsForResource(givenResourceType);
        return dbAuthorization.getPermissions(permissionsByResourceType);
    }
}

