/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.dto.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.history.CleanableHistoricCaseInstanceReport;
import io.orqueio.bpm.engine.rest.dto.AbstractQueryDto;
import io.orqueio.bpm.engine.rest.dto.OrqueioQueryParam;
import io.orqueio.bpm.engine.rest.dto.converter.BooleanConverter;
import io.orqueio.bpm.engine.rest.dto.converter.StringArrayConverter;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CleanableHistoricCaseInstanceReportDto
extends AbstractQueryDto<CleanableHistoricCaseInstanceReport> {
    protected String[] caseDefinitionIdIn;
    protected String[] caseDefinitionKeyIn;
    protected String[] tenantIdIn;
    protected Boolean withoutTenantId;
    protected Boolean compact;
    protected static final String SORT_BY_FINISHED_VALUE = "finished";
    public static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();

    public CleanableHistoricCaseInstanceReportDto() {
    }

    public CleanableHistoricCaseInstanceReportDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @OrqueioQueryParam(value="caseDefinitionIdIn", converter=StringArrayConverter.class)
    public void setCaseDefinitionIdIn(String[] caseDefinitionIdIn) {
        this.caseDefinitionIdIn = caseDefinitionIdIn;
    }

    @OrqueioQueryParam(value="caseDefinitionKeyIn", converter=StringArrayConverter.class)
    public void setCaseDefinitionKeyIn(String[] caseDefinitionKeyIn) {
        this.caseDefinitionKeyIn = caseDefinitionKeyIn;
    }

    @OrqueioQueryParam(value="tenantIdIn", converter=StringArrayConverter.class)
    public void setTenantIdIn(String[] tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
    }

    @OrqueioQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    @OrqueioQueryParam(value="compact", converter=BooleanConverter.class)
    public void setCompact(Boolean compact) {
        this.compact = compact;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected CleanableHistoricCaseInstanceReport createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createCleanableHistoricCaseInstanceReport();
    }

    @Override
    protected void applyFilters(CleanableHistoricCaseInstanceReport query) {
        if (this.caseDefinitionIdIn != null && this.caseDefinitionIdIn.length > 0) {
            query.caseDefinitionIdIn(this.caseDefinitionIdIn);
        }
        if (this.caseDefinitionKeyIn != null && this.caseDefinitionKeyIn.length > 0) {
            query.caseDefinitionKeyIn(this.caseDefinitionKeyIn);
        }
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
        if (this.tenantIdIn != null && this.tenantIdIn.length > 0) {
            query.tenantIdIn(this.tenantIdIn);
        }
        if (Boolean.TRUE.equals(this.compact)) {
            query.compact();
        }
    }

    @Override
    protected void applySortBy(CleanableHistoricCaseInstanceReport query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_FINISHED_VALUE)) {
            query.orderByFinished();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_FINISHED_VALUE);
    }
}

