/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.dto.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.history.HistoricExternalTaskLogQuery;
import io.orqueio.bpm.engine.rest.dto.AbstractQueryDto;
import io.orqueio.bpm.engine.rest.dto.OrqueioQueryParam;
import io.orqueio.bpm.engine.rest.dto.converter.BooleanConverter;
import io.orqueio.bpm.engine.rest.dto.converter.LongConverter;
import io.orqueio.bpm.engine.rest.dto.converter.StringArrayConverter;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HistoricExternalTaskLogQueryDto
extends AbstractQueryDto<HistoricExternalTaskLogQuery> {
    protected static final String SORT_BY_TIMESTAMP = "timestamp";
    protected static final String SORT_BY_EXTERNAL_TASK_ID = "externalTaskId";
    protected static final String SORT_BY_RETRIES = "retries";
    protected static final String SORT_BY_PRIORITY = "priority";
    protected static final String SORT_BY_TOPIC_NAME = "topicName";
    protected static final String SORT_BY_WORKER_ID = "workerId";
    protected static final String SORT_BY_ACTIVITY_ID = "activityId";
    protected static final String SORT_BY_ACTIVITY_INSTANCE_ID = "activityInstanceId";
    protected static final String SORT_BY_EXECUTION_ID = "executionId";
    protected static final String SORT_BY_PROCESS_INSTANCE_ID = "processInstanceId";
    protected static final String SORT_BY_PROCESS_DEFINITION_ID = "processDefinitionId";
    protected static final String SORT_BY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    protected static final String SORT_BY_TENANT_ID = "tenantId";
    protected static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected String id;
    protected String externalTaskId;
    protected String topicName;
    protected String workerId;
    protected String errorMessage;
    protected String[] activityIds;
    protected String[] activityInstanceIds;
    protected String[] executionIds;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected Long priorityHigherThanOrEquals;
    protected Long priorityLowerThanOrEquals;
    protected String[] tenantIds;
    protected Boolean withoutTenantId;
    protected Boolean creationLog;
    protected Boolean failureLog;
    protected Boolean successLog;
    protected Boolean deletionLog;

    public HistoricExternalTaskLogQueryDto() {
    }

    public HistoricExternalTaskLogQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @OrqueioQueryParam(value="logId")
    public void setLogId(String id) {
        this.id = id;
    }

    @OrqueioQueryParam(value="externalTaskId")
    public void setExternalTaskId(String externalTaskId) {
        this.externalTaskId = externalTaskId;
    }

    @OrqueioQueryParam(value="topicName")
    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    @OrqueioQueryParam(value="workerId")
    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    @OrqueioQueryParam(value="errorMessage")
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @OrqueioQueryParam(value="activityIdIn", converter=StringArrayConverter.class)
    public void setActivityIdIn(String[] activityIds) {
        this.activityIds = activityIds;
    }

    @OrqueioQueryParam(value="activityInstanceIdIn", converter=StringArrayConverter.class)
    public void setActivityInstanceIdIn(String[] activityInstanceIds) {
        this.activityInstanceIds = activityInstanceIds;
    }

    @OrqueioQueryParam(value="executionIdIn", converter=StringArrayConverter.class)
    public void setExecutionIdIn(String[] executionIds) {
        this.executionIds = executionIds;
    }

    @OrqueioQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @OrqueioQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @OrqueioQueryParam(value="processDefinitionKey")
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @OrqueioQueryParam(value="priorityHigherThanOrEquals", converter=LongConverter.class)
    public void setPriorityHigherThanOrEquals(Long priorityHigherThanOrEquals) {
        this.priorityHigherThanOrEquals = priorityHigherThanOrEquals;
    }

    @OrqueioQueryParam(value="priorityLowerThanOrEquals", converter=LongConverter.class)
    public void setPriorityLowerThanOrEquals(Long priorityLowerThanOrEquals) {
        this.priorityLowerThanOrEquals = priorityLowerThanOrEquals;
    }

    @OrqueioQueryParam(value="tenantIdIn", converter=StringArrayConverter.class)
    public void setTenantIdIn(String[] tenantIds) {
        this.tenantIds = tenantIds;
    }

    @OrqueioQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    @OrqueioQueryParam(value="creationLog", converter=BooleanConverter.class)
    public void setCreationLog(Boolean creationLog) {
        this.creationLog = creationLog;
    }

    @OrqueioQueryParam(value="failureLog", converter=BooleanConverter.class)
    public void setFailureLog(Boolean failureLog) {
        this.failureLog = failureLog;
    }

    @OrqueioQueryParam(value="successLog", converter=BooleanConverter.class)
    public void setSuccessLog(Boolean successLog) {
        this.successLog = successLog;
    }

    @OrqueioQueryParam(value="deletionLog", converter=BooleanConverter.class)
    public void setDeletionLog(Boolean deletionLog) {
        this.deletionLog = deletionLog;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected HistoricExternalTaskLogQuery createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createHistoricExternalTaskLogQuery();
    }

    @Override
    protected void applyFilters(HistoricExternalTaskLogQuery query) {
        if (this.id != null) {
            query.logId(this.id);
        }
        if (this.externalTaskId != null) {
            query.externalTaskId(this.externalTaskId);
        }
        if (this.topicName != null) {
            query.topicName(this.topicName);
        }
        if (this.workerId != null) {
            query.workerId(this.workerId);
        }
        if (this.errorMessage != null) {
            query.errorMessage(this.errorMessage);
        }
        if (this.activityIds != null && this.activityIds.length > 0) {
            query.activityIdIn(this.activityIds);
        }
        if (this.activityInstanceIds != null && this.activityInstanceIds.length > 0) {
            query.activityInstanceIdIn(this.activityInstanceIds);
        }
        if (this.executionIds != null && this.executionIds.length > 0) {
            query.executionIdIn(this.executionIds);
        }
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.processDefinitionKey != null) {
            query.processDefinitionKey(this.processDefinitionKey);
        }
        if (this.creationLog != null && this.creationLog.booleanValue()) {
            query.creationLog();
        }
        if (this.failureLog != null && this.failureLog.booleanValue()) {
            query.failureLog();
        }
        if (this.successLog != null && this.successLog.booleanValue()) {
            query.successLog();
        }
        if (this.deletionLog != null && this.deletionLog.booleanValue()) {
            query.deletionLog();
        }
        if (this.priorityHigherThanOrEquals != null) {
            query.priorityHigherThanOrEquals(this.priorityHigherThanOrEquals.longValue());
        }
        if (this.priorityLowerThanOrEquals != null) {
            query.priorityLowerThanOrEquals(this.priorityLowerThanOrEquals.longValue());
        }
        if (this.tenantIds != null && this.tenantIds.length > 0) {
            query.tenantIdIn(this.tenantIds);
        }
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
    }

    @Override
    protected void applySortBy(HistoricExternalTaskLogQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_TIMESTAMP)) {
            query.orderByTimestamp();
        } else if (sortBy.equals(SORT_BY_EXTERNAL_TASK_ID)) {
            query.orderByExternalTaskId();
        } else if (sortBy.equals(SORT_BY_RETRIES)) {
            query.orderByRetries();
        } else if (sortBy.equals(SORT_BY_PRIORITY)) {
            query.orderByPriority();
        } else if (sortBy.equals(SORT_BY_TOPIC_NAME)) {
            query.orderByTopicName();
        } else if (sortBy.equals(SORT_BY_WORKER_ID)) {
            query.orderByWorkerId();
        } else if (sortBy.equals(SORT_BY_ACTIVITY_ID)) {
            query.orderByActivityId();
        } else if (sortBy.equals(SORT_BY_ACTIVITY_INSTANCE_ID)) {
            query.orderByActivityInstanceId();
        } else if (sortBy.equals(SORT_BY_EXECUTION_ID)) {
            query.orderByExecutionId();
        } else if (sortBy.equals(SORT_BY_PROCESS_INSTANCE_ID)) {
            query.orderByProcessInstanceId();
        } else if (sortBy.equals(SORT_BY_PROCESS_DEFINITION_ID)) {
            query.orderByProcessDefinitionId();
        } else if (sortBy.equals(SORT_BY_PROCESS_DEFINITION_KEY)) {
            query.orderByProcessDefinitionKey();
        } else if (sortBy.equals(SORT_BY_TENANT_ID)) {
            query.orderByTenantId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_TIMESTAMP);
        VALID_SORT_BY_VALUES.add(SORT_BY_EXTERNAL_TASK_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_RETRIES);
        VALID_SORT_BY_VALUES.add(SORT_BY_PRIORITY);
        VALID_SORT_BY_VALUES.add(SORT_BY_TOPIC_NAME);
        VALID_SORT_BY_VALUES.add(SORT_BY_WORKER_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_ACTIVITY_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_ACTIVITY_INSTANCE_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_EXECUTION_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_KEY);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
    }
}

