/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.dto.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.history.HistoricProcessInstanceQuery;
import io.orqueio.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import io.orqueio.bpm.engine.rest.dto.AbstractQueryDto;
import io.orqueio.bpm.engine.rest.dto.OrqueioQueryParam;
import io.orqueio.bpm.engine.rest.dto.VariableQueryParameterDto;
import io.orqueio.bpm.engine.rest.dto.converter.BooleanConverter;
import io.orqueio.bpm.engine.rest.dto.converter.DateConverter;
import io.orqueio.bpm.engine.rest.dto.converter.StringListConverter;
import io.orqueio.bpm.engine.rest.dto.converter.StringSetConverter;
import io.orqueio.bpm.engine.rest.dto.converter.VariableListConverter;
import io.orqueio.bpm.engine.rest.exception.InvalidRequestException;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HistoricProcessInstanceQueryDto
extends AbstractQueryDto<HistoricProcessInstanceQuery> {
    private static final String SORT_BY_PROCESS_INSTANCE_ID_VALUE = "instanceId";
    private static final String SORT_BY_PROCESS_DEFINITION_ID_VALUE = "definitionId";
    private static final String SORT_BY_PROCESS_INSTANCE_BUSINESS_KEY_VALUE = "businessKey";
    private static final String SORT_BY_PROCESS_INSTANCE_START_TIME_VALUE = "startTime";
    private static final String SORT_BY_PROCESS_INSTANCE_END_TIME_VALUE = "endTime";
    private static final String SORT_BY_PROCESS_INSTANCE_DURATION_VALUE = "duration";
    private static final String SORT_BY_PROCESS_DEFINITION_KEY_VALUE = "definitionKey";
    private static final String SORT_BY_PROCESS_DEFINITION_NAME_VALUE = "definitionName";
    private static final String SORT_BY_PROCESS_DEFINITION_VERSION_VALUE = "definitionVersion";
    private static final String SORT_BY_TENANT_ID = "tenantId";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    private String processInstanceId;
    private Set<String> processInstanceIds;
    private List<String> processInstanceIdNotIn;
    private String rootProcessInstanceId;
    private String processDefinitionId;
    private String processDefinitionKey;
    private List<String> processDefinitionKeys;
    private String processDefinitionName;
    private String processDefinitionNameLike;
    private List<String> processDefinitionKeyNotIn;
    private String processInstanceBusinessKey;
    private List<String> processInstanceBusinessKeyIn;
    private String processInstanceBusinessKeyLike;
    private Boolean rootProcessInstances;
    private Boolean finished;
    private Boolean unfinished;
    private Boolean withJobsRetrying;
    private Boolean withIncidents;
    private Boolean withRootIncidents;
    private String incidentType;
    private String incidentStatus;
    private String incidentMessage;
    private String incidentMessageLike;
    private Date startedBefore;
    private Date startedAfter;
    private Date finishedBefore;
    private Date finishedAfter;
    private Date executedActivityAfter;
    private Date executedActivityBefore;
    private Date executedJobAfter;
    private Date executedJobBefore;
    private String startedBy;
    private String superProcessInstanceId;
    private String subProcessInstanceId;
    private String superCaseInstanceId;
    private String subCaseInstanceId;
    private String caseInstanceId;
    private List<String> tenantIds;
    private Boolean withoutTenantId;
    private List<String> executedActivityIdIn;
    private List<String> activeActivityIdIn;
    private List<String> activityIdIn;
    private Boolean active;
    private Boolean suspended;
    private Boolean completed;
    private Boolean externallyTerminated;
    private Boolean internallyTerminated;
    private List<String> incidentIds;
    private List<VariableQueryParameterDto> variables;
    protected Boolean variableNamesIgnoreCase;
    protected Boolean variableValuesIgnoreCase;
    private List<HistoricProcessInstanceQueryDto> orQueries;

    public HistoricProcessInstanceQueryDto() {
    }

    public HistoricProcessInstanceQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @OrqueioQueryParam(value="orQueries")
    public void setOrQueries(List<HistoricProcessInstanceQueryDto> orQueries) {
        this.orQueries = orQueries;
    }

    @OrqueioQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @OrqueioQueryParam(value="processInstanceIds", converter=StringSetConverter.class)
    public void setProcessInstanceIds(Set<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
    }

    @OrqueioQueryParam(value="processInstanceIdNotIn", converter=StringListConverter.class)
    public void setProcessInstanceIdNotIn(List<String> processInstanceIdNotIn) {
        this.processInstanceIdNotIn = processInstanceIdNotIn;
    }

    public String getRootProcessInstanceId() {
        return this.rootProcessInstanceId;
    }

    @OrqueioQueryParam(value="rootProcessInstanceId")
    public void setRootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @OrqueioQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @OrqueioQueryParam(value="processDefinitionName")
    public void setProcessDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
    }

    @OrqueioQueryParam(value="processDefinitionNameLike")
    public void setProcessDefinitionNameLike(String processDefinitionNameLike) {
        this.processDefinitionNameLike = processDefinitionNameLike;
    }

    @OrqueioQueryParam(value="processDefinitionKey")
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @OrqueioQueryParam(value="processDefinitionKeyIn", converter=StringListConverter.class)
    public void setProcessDefinitionKeyIn(List<String> processDefinitionKeys) {
        this.processDefinitionKeys = processDefinitionKeys;
    }

    @OrqueioQueryParam(value="processDefinitionKeyNotIn", converter=StringListConverter.class)
    public void setProcessDefinitionKeyNotIn(List<String> processDefinitionKeys) {
        this.processDefinitionKeyNotIn = processDefinitionKeys;
    }

    @OrqueioQueryParam(value="processInstanceBusinessKey")
    public void setProcessInstanceBusinessKey(String processInstanceBusinessKey) {
        this.processInstanceBusinessKey = processInstanceBusinessKey;
    }

    @OrqueioQueryParam(value="processInstanceBusinessKeyIn", converter=StringListConverter.class)
    public void setProcessInstanceBusinessKeyIn(List<String> processInstanceBusinessKeyIn) {
        this.processInstanceBusinessKeyIn = processInstanceBusinessKeyIn;
    }

    @OrqueioQueryParam(value="processInstanceBusinessKeyLike")
    public void setProcessInstanceBusinessKeyLike(String processInstanceBusinessKeyLike) {
        this.processInstanceBusinessKeyLike = processInstanceBusinessKeyLike;
    }

    @OrqueioQueryParam(value="rootProcessInstances", converter=BooleanConverter.class)
    public void setRootProcessInstances(Boolean rootProcessInstances) {
        this.rootProcessInstances = rootProcessInstances;
    }

    @OrqueioQueryParam(value="finished", converter=BooleanConverter.class)
    public void setFinished(Boolean finished) {
        this.finished = finished;
    }

    @OrqueioQueryParam(value="unfinished", converter=BooleanConverter.class)
    public void setUnfinished(Boolean unfinished) {
        this.unfinished = unfinished;
    }

    @OrqueioQueryParam(value="withJobsRetrying", converter=BooleanConverter.class)
    public void setWithJobsRetrying(Boolean withJobsRetrying) {
        this.withJobsRetrying = withJobsRetrying;
    }

    @OrqueioQueryParam(value="withIncidents", converter=BooleanConverter.class)
    public void setWithIncidents(Boolean withIncidents) {
        this.withIncidents = withIncidents;
    }

    @OrqueioQueryParam(value="withRootIncidents", converter=BooleanConverter.class)
    public void setWithRootIncidents(Boolean withRootIncidents) {
        this.withRootIncidents = withRootIncidents;
    }

    @OrqueioQueryParam(value="incidentStatus")
    public void setIncidentStatus(String status) {
        this.incidentStatus = status;
    }

    @OrqueioQueryParam(value="incidentMessage")
    public void setIncidentMessage(String incidentMessage) {
        this.incidentMessage = incidentMessage;
    }

    @OrqueioQueryParam(value="incidentMessageLike")
    public void setIncidentMessageLike(String incidentMessageLike) {
        this.incidentMessageLike = incidentMessageLike;
    }

    @OrqueioQueryParam(value="startedBefore", converter=DateConverter.class)
    public void setStartedBefore(Date startedBefore) {
        this.startedBefore = startedBefore;
    }

    @OrqueioQueryParam(value="startedAfter", converter=DateConverter.class)
    public void setStartedAfter(Date startedAfter) {
        this.startedAfter = startedAfter;
    }

    @OrqueioQueryParam(value="finishedBefore", converter=DateConverter.class)
    public void setFinishedBefore(Date finishedBefore) {
        this.finishedBefore = finishedBefore;
    }

    @OrqueioQueryParam(value="finishedAfter", converter=DateConverter.class)
    public void setFinishedAfter(Date finishedAfter) {
        this.finishedAfter = finishedAfter;
    }

    @OrqueioQueryParam(value="startedBy")
    public void setStartedBy(String startedBy) {
        this.startedBy = startedBy;
    }

    @OrqueioQueryParam(value="superProcessInstanceId")
    public void setSuperProcessInstanceId(String superProcessInstanceId) {
        this.superProcessInstanceId = superProcessInstanceId;
    }

    @OrqueioQueryParam(value="subProcessInstanceId")
    public void setSubProcessInstanceId(String subProcessInstanceId) {
        this.subProcessInstanceId = subProcessInstanceId;
    }

    @OrqueioQueryParam(value="superCaseInstanceId")
    public void setSuperCaseInstanceId(String superCaseInstanceId) {
        this.superCaseInstanceId = superCaseInstanceId;
    }

    @OrqueioQueryParam(value="subCaseInstanceId")
    public void setSubCaseInstanceId(String subCaseInstanceId) {
        this.subCaseInstanceId = subCaseInstanceId;
    }

    @OrqueioQueryParam(value="caseInstanceId")
    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @OrqueioQueryParam(value="variables", converter=VariableListConverter.class)
    public void setVariables(List<VariableQueryParameterDto> variables) {
        this.variables = variables;
    }

    @OrqueioQueryParam(value="variableNamesIgnoreCase", converter=BooleanConverter.class)
    public void setVariableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
        this.variableNamesIgnoreCase = variableNamesIgnoreCase;
    }

    @OrqueioQueryParam(value="variableValuesIgnoreCase", converter=BooleanConverter.class)
    public void setVariableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
        this.variableValuesIgnoreCase = variableValuesIgnoreCase;
    }

    public String getIncidentType() {
        return this.incidentType;
    }

    @OrqueioQueryParam(value="incidentType")
    public void setIncidentType(String incidentType) {
        this.incidentType = incidentType;
    }

    @OrqueioQueryParam(value="incidentIdIn", converter=StringListConverter.class)
    public void setIncidentIdIn(List<String> incidentIds) {
        this.incidentIds = incidentIds;
    }

    @OrqueioQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @OrqueioQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    @OrqueioQueryParam(value="executedActivityAfter", converter=DateConverter.class)
    public void setExecutedActivityAfter(Date executedActivityAfter) {
        this.executedActivityAfter = executedActivityAfter;
    }

    @OrqueioQueryParam(value="executedActivityIdIn", converter=StringListConverter.class)
    public void setExecutedActivityIdIn(List<String> executedActivityIds) {
        this.executedActivityIdIn = executedActivityIds;
    }

    @OrqueioQueryParam(value="executedActivityBefore", converter=DateConverter.class)
    public void setExecutedActivityBefore(Date executedActivityBefore) {
        this.executedActivityBefore = executedActivityBefore;
    }

    @OrqueioQueryParam(value="activeActivityIdIn", converter=StringListConverter.class)
    public void setActiveActivityIdIn(List<String> activeActivityIdIn) {
        this.activeActivityIdIn = activeActivityIdIn;
    }

    @OrqueioQueryParam(value="activityIdIn", converter=StringListConverter.class)
    public void setActivityIdIn(List<String> activityIdIn) {
        this.activityIdIn = activityIdIn;
    }

    @OrqueioQueryParam(value="executedJobAfter", converter=DateConverter.class)
    public void setExecutedJobAfter(Date executedJobAfter) {
        this.executedJobAfter = executedJobAfter;
    }

    @OrqueioQueryParam(value="executedJobBefore", converter=DateConverter.class)
    public void setExecutedJobBefore(Date executedJobBefore) {
        this.executedJobBefore = executedJobBefore;
    }

    @OrqueioQueryParam(value="active", converter=BooleanConverter.class)
    public void setActive(Boolean active) {
        this.active = active;
    }

    @OrqueioQueryParam(value="suspended", converter=BooleanConverter.class)
    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    @OrqueioQueryParam(value="completed", converter=BooleanConverter.class)
    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    @OrqueioQueryParam(value="externallyTerminated", converter=BooleanConverter.class)
    public void setExternallyTerminated(Boolean externallyTerminated) {
        this.externallyTerminated = externallyTerminated;
    }

    @OrqueioQueryParam(value="internallyTerminated", converter=BooleanConverter.class)
    public void setInternallyTerminated(Boolean internallyTerminated) {
        this.internallyTerminated = internallyTerminated;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected HistoricProcessInstanceQuery createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createHistoricProcessInstanceQuery();
    }

    public List<HistoricProcessInstanceQueryDto> getOrQueries() {
        return this.orQueries;
    }

    @Override
    protected void applyFilters(HistoricProcessInstanceQuery query) {
        if (this.orQueries != null) {
            for (HistoricProcessInstanceQueryDto orQueryDto : this.orQueries) {
                HistoricProcessInstanceQueryImpl orQuery = new HistoricProcessInstanceQueryImpl();
                orQuery.setOrQueryActive();
                orQueryDto.applyFilters((HistoricProcessInstanceQuery)orQuery);
                ((HistoricProcessInstanceQueryImpl)query).addOrQuery(orQuery);
            }
        }
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.processInstanceIds != null) {
            query.processInstanceIds(this.processInstanceIds);
        }
        if (this.processInstanceIdNotIn != null && !this.processInstanceIdNotIn.isEmpty()) {
            query.processInstanceIdNotIn(this.processInstanceIdNotIn.toArray(new String[0]));
        }
        if (this.rootProcessInstanceId != null) {
            query.rootProcessInstanceId(this.rootProcessInstanceId);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.processDefinitionKey != null) {
            query.processDefinitionKey(this.processDefinitionKey);
        }
        if (this.processDefinitionKeys != null && !this.processDefinitionKeys.isEmpty()) {
            query.processDefinitionKeyIn(this.processDefinitionKeys.toArray(new String[0]));
        }
        if (this.processDefinitionName != null) {
            query.processDefinitionName(this.processDefinitionName);
        }
        if (this.processDefinitionNameLike != null) {
            query.processDefinitionNameLike(this.processDefinitionNameLike);
        }
        if (this.processDefinitionKeyNotIn != null) {
            query.processDefinitionKeyNotIn(this.processDefinitionKeyNotIn);
        }
        if (this.processInstanceBusinessKey != null) {
            query.processInstanceBusinessKey(this.processInstanceBusinessKey);
        }
        if (this.processInstanceBusinessKeyIn != null && !this.processInstanceBusinessKeyIn.isEmpty()) {
            query.processInstanceBusinessKeyIn(this.processInstanceBusinessKeyIn.toArray(new String[0]));
        }
        if (this.processInstanceBusinessKeyLike != null) {
            query.processInstanceBusinessKeyLike(this.processInstanceBusinessKeyLike);
        }
        if (this.rootProcessInstances != null && this.rootProcessInstances.booleanValue()) {
            query.rootProcessInstances();
        }
        if (this.finished != null && this.finished.booleanValue()) {
            query.finished();
        }
        if (this.unfinished != null && this.unfinished.booleanValue()) {
            query.unfinished();
        }
        if (this.withJobsRetrying != null && this.withJobsRetrying.booleanValue()) {
            query.withJobsRetrying();
        }
        if (this.withIncidents != null && this.withIncidents.booleanValue()) {
            query.withIncidents();
        }
        if (this.withRootIncidents != null && this.withRootIncidents.booleanValue()) {
            query.withRootIncidents();
        }
        if (this.incidentIds != null && !this.incidentIds.isEmpty()) {
            query.incidentIdIn(this.incidentIds.toArray(new String[0]));
        }
        if (this.incidentStatus != null) {
            query.incidentStatus(this.incidentStatus);
        }
        if (this.incidentType != null) {
            query.incidentType(this.incidentType);
        }
        if (this.incidentMessage != null) {
            query.incidentMessage(this.incidentMessage);
        }
        if (this.incidentMessageLike != null) {
            query.incidentMessageLike(this.incidentMessageLike);
        }
        if (this.startedBefore != null) {
            query.startedBefore(this.startedBefore);
        }
        if (this.startedAfter != null) {
            query.startedAfter(this.startedAfter);
        }
        if (this.finishedBefore != null) {
            query.finishedBefore(this.finishedBefore);
        }
        if (this.finishedAfter != null) {
            query.finishedAfter(this.finishedAfter);
        }
        if (this.startedBy != null) {
            query.startedBy(this.startedBy);
        }
        if (this.superProcessInstanceId != null) {
            query.superProcessInstanceId(this.superProcessInstanceId);
        }
        if (this.subProcessInstanceId != null) {
            query.subProcessInstanceId(this.subProcessInstanceId);
        }
        if (this.superCaseInstanceId != null) {
            query.superCaseInstanceId(this.superCaseInstanceId);
        }
        if (this.subCaseInstanceId != null) {
            query.subCaseInstanceId(this.subCaseInstanceId);
        }
        if (this.caseInstanceId != null) {
            query.caseInstanceId(this.caseInstanceId);
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[0]));
        }
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
        if (Boolean.TRUE.equals(this.variableNamesIgnoreCase)) {
            query.matchVariableNamesIgnoreCase();
        }
        if (Boolean.TRUE.equals(this.variableValuesIgnoreCase)) {
            query.matchVariableValuesIgnoreCase();
        }
        if (this.variables != null) {
            for (VariableQueryParameterDto variableQueryParam : this.variables) {
                String variableName = variableQueryParam.getName();
                String op = variableQueryParam.getOperator();
                Object variableValue = variableQueryParam.resolveValue(this.objectMapper);
                if (op.equals("eq")) {
                    query.variableValueEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("gt")) {
                    query.variableValueGreaterThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("gteq")) {
                    query.variableValueGreaterThanOrEqual(variableName, variableValue);
                    continue;
                }
                if (op.equals("lt")) {
                    query.variableValueLessThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("lteq")) {
                    query.variableValueLessThanOrEqual(variableName, variableValue);
                    continue;
                }
                if (op.equals("neq")) {
                    query.variableValueNotEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("like")) {
                    query.variableValueLike(variableName, String.valueOf(variableValue));
                    continue;
                }
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Invalid variable comparator specified: " + op);
            }
        }
        if (this.executedActivityAfter != null) {
            query.executedActivityAfter(this.executedActivityAfter);
        }
        if (this.executedActivityBefore != null) {
            query.executedActivityBefore(this.executedActivityBefore);
        }
        if (this.executedActivityIdIn != null && !this.executedActivityIdIn.isEmpty()) {
            query.executedActivityIdIn(this.executedActivityIdIn.toArray(new String[0]));
        }
        if (this.activeActivityIdIn != null && !this.activeActivityIdIn.isEmpty()) {
            query.activeActivityIdIn(this.activeActivityIdIn.toArray(new String[0]));
        }
        if (this.activityIdIn != null && !this.activityIdIn.isEmpty()) {
            query.activityIdIn(this.activityIdIn.toArray(new String[0]));
        }
        if (this.executedJobAfter != null) {
            query.executedJobAfter(this.executedJobAfter);
        }
        if (this.executedJobBefore != null) {
            query.executedJobBefore(this.executedJobBefore);
        }
        if (this.active != null && this.active.booleanValue()) {
            query.active();
        }
        if (this.suspended != null && this.suspended.booleanValue()) {
            query.suspended();
        }
        if (this.completed != null && this.completed.booleanValue()) {
            query.completed();
        }
        if (this.externallyTerminated != null && this.externallyTerminated.booleanValue()) {
            query.externallyTerminated();
        }
        if (this.internallyTerminated != null && this.internallyTerminated.booleanValue()) {
            query.internallyTerminated();
        }
    }

    @Override
    protected void applySortBy(HistoricProcessInstanceQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_PROCESS_INSTANCE_ID_VALUE)) {
            query.orderByProcessInstanceId();
        } else if (sortBy.equals(SORT_BY_PROCESS_DEFINITION_ID_VALUE)) {
            query.orderByProcessDefinitionId();
        } else if (sortBy.equals(SORT_BY_PROCESS_DEFINITION_KEY_VALUE)) {
            query.orderByProcessDefinitionKey();
        } else if (sortBy.equals(SORT_BY_PROCESS_DEFINITION_NAME_VALUE)) {
            query.orderByProcessDefinitionName();
        } else if (sortBy.equals(SORT_BY_PROCESS_DEFINITION_VERSION_VALUE)) {
            query.orderByProcessDefinitionVersion();
        } else if (sortBy.equals(SORT_BY_PROCESS_INSTANCE_BUSINESS_KEY_VALUE)) {
            query.orderByProcessInstanceBusinessKey();
        } else if (sortBy.equals(SORT_BY_PROCESS_INSTANCE_START_TIME_VALUE)) {
            query.orderByProcessInstanceStartTime();
        } else if (sortBy.equals(SORT_BY_PROCESS_INSTANCE_END_TIME_VALUE)) {
            query.orderByProcessInstanceEndTime();
        } else if (sortBy.equals(SORT_BY_PROCESS_INSTANCE_DURATION_VALUE)) {
            query.orderByProcessInstanceDuration();
        } else if (sortBy.equals(SORT_BY_TENANT_ID)) {
            query.orderByTenantId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_BUSINESS_KEY_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_START_TIME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_END_TIME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_DURATION_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_KEY_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_NAME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_VERSION_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
    }
}

