/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.dto.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.history.UserOperationLogQuery;
import io.orqueio.bpm.engine.rest.dto.AbstractQueryDto;
import io.orqueio.bpm.engine.rest.dto.OrqueioQueryParam;
import io.orqueio.bpm.engine.rest.dto.converter.DateConverter;
import io.orqueio.bpm.engine.rest.dto.converter.StringArrayConverter;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Date;
import java.util.Map;

public class UserOperationLogQueryDto
extends AbstractQueryDto<UserOperationLogQuery> {
    public static final String TIMESTAMP = "timestamp";
    protected String deploymentId;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String processInstanceId;
    protected String executionId;
    protected String caseDefinitionId;
    protected String caseInstanceId;
    protected String caseExecutionId;
    protected String taskId;
    protected String jobId;
    protected String jobDefinitionId;
    protected String batchId;
    protected String userId;
    protected String operationId;
    protected String externalTaskId;
    protected String operationType;
    protected String entityType;
    protected String property;
    protected String category;
    protected Date afterTimestamp;
    protected Date beforeTimestamp;
    protected String[] entityTypes;
    protected String[] categories;

    public UserOperationLogQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return TIMESTAMP.equals(value);
    }

    @Override
    protected UserOperationLogQuery createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createUserOperationLogQuery();
    }

    @Override
    protected void applyFilters(UserOperationLogQuery query) {
        if (this.deploymentId != null) {
            query.deploymentId(this.deploymentId);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.processDefinitionKey != null) {
            query.processDefinitionKey(this.processDefinitionKey);
        }
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.executionId != null) {
            query.executionId(this.executionId);
        }
        if (this.caseDefinitionId != null) {
            query.caseDefinitionId(this.caseDefinitionId);
        }
        if (this.caseInstanceId != null) {
            query.caseInstanceId(this.caseInstanceId);
        }
        if (this.caseExecutionId != null) {
            query.caseExecutionId(this.caseExecutionId);
        }
        if (this.taskId != null) {
            query.taskId(this.taskId);
        }
        if (this.jobId != null) {
            query.jobId(this.jobId);
        }
        if (this.jobDefinitionId != null) {
            query.jobDefinitionId(this.jobDefinitionId);
        }
        if (this.batchId != null) {
            query.batchId(this.batchId);
        }
        if (this.userId != null) {
            query.userId(this.userId);
        }
        if (this.operationId != null) {
            query.operationId(this.operationId);
        }
        if (this.externalTaskId != null) {
            query.externalTaskId(this.externalTaskId);
        }
        if (this.operationType != null) {
            query.operationType(this.operationType);
        }
        if (this.entityType != null) {
            query.entityType(this.entityType);
        }
        if (this.entityTypes != null) {
            query.entityTypeIn(this.entityTypes);
        }
        if (this.category != null) {
            query.category(this.category);
        }
        if (this.categories != null) {
            query.categoryIn(this.categories);
        }
        if (this.property != null) {
            query.property(this.property);
        }
        if (this.afterTimestamp != null) {
            query.afterTimestamp(this.afterTimestamp);
        }
        if (this.beforeTimestamp != null) {
            query.beforeTimestamp(this.beforeTimestamp);
        }
    }

    @Override
    protected void applySortBy(UserOperationLogQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (TIMESTAMP.equals(sortBy)) {
            query.orderByTimestamp();
        }
    }

    @OrqueioQueryParam(value="deploymentId")
    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    @OrqueioQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @OrqueioQueryParam(value="processDefinitionKey")
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @OrqueioQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @OrqueioQueryParam(value="executionId")
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @OrqueioQueryParam(value="caseDefinitionId")
    public void setCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    @OrqueioQueryParam(value="caseInstanceId")
    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @OrqueioQueryParam(value="caseExecutionId")
    public void setCaseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
    }

    @OrqueioQueryParam(value="taskId")
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @OrqueioQueryParam(value="jobId")
    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    @OrqueioQueryParam(value="jobDefinitionId")
    public void setJobDefinitionId(String jobDefinitionId) {
        this.jobDefinitionId = jobDefinitionId;
    }

    @OrqueioQueryParam(value="batchId")
    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    @OrqueioQueryParam(value="userId")
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @OrqueioQueryParam(value="operationId")
    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    @OrqueioQueryParam(value="externalTaskId")
    public void setExternalTaskId(String externalTaskId) {
        this.externalTaskId = externalTaskId;
    }

    @OrqueioQueryParam(value="operationType")
    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    @OrqueioQueryParam(value="entityType")
    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    @OrqueioQueryParam(value="entityTypeIn", converter=StringArrayConverter.class)
    public void setEntityTypeIn(String[] entityTypes) {
        this.entityTypes = entityTypes;
    }

    @OrqueioQueryParam(value="category")
    public void setcategory(String category) {
        this.category = category;
    }

    @OrqueioQueryParam(value="categoryIn", converter=StringArrayConverter.class)
    public void setCategoryIn(String[] categories) {
        this.categories = categories;
    }

    @OrqueioQueryParam(value="property")
    public void setProperty(String property) {
        this.property = property;
    }

    @OrqueioQueryParam(value="afterTimestamp", converter=DateConverter.class)
    public void setAfterTimestamp(Date after) {
        this.afterTimestamp = after;
    }

    @OrqueioQueryParam(value="beforeTimestamp", converter=DateConverter.class)
    public void setBeforeTimestamp(Date before) {
        this.beforeTimestamp = before;
    }
}

