/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.dto.migration;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.migration.MigrationInstruction;
import io.orqueio.bpm.engine.migration.MigrationInstructionBuilder;
import io.orqueio.bpm.engine.migration.MigrationPlan;
import io.orqueio.bpm.engine.migration.MigrationPlanBuilder;
import io.orqueio.bpm.engine.rest.dto.VariableValueDto;
import io.orqueio.bpm.engine.rest.dto.migration.MigrationInstructionDto;
import io.orqueio.bpm.engine.variable.VariableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MigrationPlanDto {
    protected String sourceProcessDefinitionId;
    protected String targetProcessDefinitionId;
    protected List<MigrationInstructionDto> instructions;
    protected Map<String, VariableValueDto> variables;

    public String getSourceProcessDefinitionId() {
        return this.sourceProcessDefinitionId;
    }

    public void setSourceProcessDefinitionId(String sourceProcessDefinitionId) {
        this.sourceProcessDefinitionId = sourceProcessDefinitionId;
    }

    public String getTargetProcessDefinitionId() {
        return this.targetProcessDefinitionId;
    }

    public void setTargetProcessDefinitionId(String targetProcessDefinitionId) {
        this.targetProcessDefinitionId = targetProcessDefinitionId;
    }

    public List<MigrationInstructionDto> getInstructions() {
        return this.instructions;
    }

    public void setInstructions(List<MigrationInstructionDto> instructions) {
        this.instructions = instructions;
    }

    public Map<String, VariableValueDto> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, VariableValueDto> variables) {
        this.variables = variables;
    }

    public static MigrationPlanDto from(MigrationPlan migrationPlan) {
        MigrationPlanDto dto = new MigrationPlanDto();
        VariableMap variables = migrationPlan.getVariables();
        if (variables != null) {
            dto.setVariables(VariableValueDto.fromMap(variables));
        }
        dto.setSourceProcessDefinitionId(migrationPlan.getSourceProcessDefinitionId());
        dto.setTargetProcessDefinitionId(migrationPlan.getTargetProcessDefinitionId());
        ArrayList<MigrationInstructionDto> instructionDtos = new ArrayList<MigrationInstructionDto>();
        if (migrationPlan.getInstructions() != null) {
            for (MigrationInstruction migrationInstruction : migrationPlan.getInstructions()) {
                MigrationInstructionDto migrationInstructionDto = MigrationInstructionDto.from(migrationInstruction);
                instructionDtos.add(migrationInstructionDto);
            }
        }
        dto.setInstructions(instructionDtos);
        return dto;
    }

    public static MigrationPlan toMigrationPlan(ProcessEngine processEngine, ObjectMapper objectMapper, MigrationPlanDto migrationPlanDto) {
        MigrationPlanBuilder migrationPlanBuilder = processEngine.getRuntimeService().createMigrationPlan(migrationPlanDto.getSourceProcessDefinitionId(), migrationPlanDto.getTargetProcessDefinitionId());
        Map<String, VariableValueDto> variableDtos = migrationPlanDto.getVariables();
        if (variableDtos != null) {
            VariableMap variables = VariableValueDto.toMap(variableDtos, processEngine, objectMapper);
            migrationPlanBuilder.setVariables((Map)variables);
        }
        if (migrationPlanDto.getInstructions() != null) {
            for (MigrationInstructionDto migrationInstructionDto : migrationPlanDto.getInstructions()) {
                MigrationInstructionBuilder migrationInstructionBuilder = migrationPlanBuilder.mapActivities(migrationInstructionDto.getSourceActivityIds().get(0), migrationInstructionDto.getTargetActivityIds().get(0));
                if (Boolean.TRUE.equals(migrationInstructionDto.isUpdateEventTrigger())) {
                    migrationInstructionBuilder = migrationInstructionBuilder.updateEventTrigger();
                }
                migrationPlanBuilder = migrationInstructionBuilder;
            }
        }
        return migrationPlanBuilder.build();
    }
}

