/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.dto.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.rest.dto.AbstractQueryDto;
import io.orqueio.bpm.engine.rest.dto.OrqueioQueryParam;
import io.orqueio.bpm.engine.rest.dto.VariableQueryParameterDto;
import io.orqueio.bpm.engine.rest.dto.converter.BooleanConverter;
import io.orqueio.bpm.engine.rest.dto.converter.StringListConverter;
import io.orqueio.bpm.engine.rest.dto.converter.VariableListConverter;
import io.orqueio.bpm.engine.rest.exception.InvalidRequestException;
import io.orqueio.bpm.engine.runtime.CaseExecutionQuery;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CaseExecutionQueryDto
extends AbstractQueryDto<CaseExecutionQuery> {
    protected static final String SORT_BY_EXECUTION_ID_VALUE = "caseExecutionId";
    protected static final String SORT_BY_DEFINITION_KEY_VALUE = "caseDefinitionKey";
    protected static final String SORT_BY_DEFINITION_ID_VALUE = "caseDefinitionId";
    protected static final String SORT_BY_TENANT_ID = "tenantId";
    protected static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected String caseExecutionId;
    protected String caseDefinitionKey;
    protected String caseDefinitionId;
    protected String caseInstanceId;
    protected String businessKey;
    protected String activityId;
    protected List<String> tenantIds;
    protected Boolean required;
    protected Boolean enabled;
    protected Boolean active;
    protected Boolean disabled;
    protected List<VariableQueryParameterDto> variables;
    protected List<VariableQueryParameterDto> caseInstanceVariables;
    protected Boolean variableNamesIgnoreCase;
    protected Boolean variableValuesIgnoreCase;

    public CaseExecutionQueryDto() {
    }

    public CaseExecutionQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @OrqueioQueryParam(value="caseExecutionId")
    public void setCaseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
    }

    @OrqueioQueryParam(value="caseDefinitionKey")
    public void setCaseDefinitionKey(String caseDefinitionKey) {
        this.caseDefinitionKey = caseDefinitionKey;
    }

    @OrqueioQueryParam(value="caseDefinitionId")
    public void setCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    @OrqueioQueryParam(value="caseInstanceId")
    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @OrqueioQueryParam(value="businessKey")
    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    @OrqueioQueryParam(value="activityId")
    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @OrqueioQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @OrqueioQueryParam(value="required", converter=BooleanConverter.class)
    public void setRequired(Boolean required) {
        this.required = required;
    }

    @OrqueioQueryParam(value="enabled", converter=BooleanConverter.class)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @OrqueioQueryParam(value="active", converter=BooleanConverter.class)
    public void setActive(Boolean active) {
        this.active = active;
    }

    @OrqueioQueryParam(value="disabled", converter=BooleanConverter.class)
    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    @OrqueioQueryParam(value="variables", converter=VariableListConverter.class)
    public void setVariables(List<VariableQueryParameterDto> variables) {
        this.variables = variables;
    }

    @OrqueioQueryParam(value="variableNamesIgnoreCase", converter=BooleanConverter.class)
    public void setVariableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
        this.variableNamesIgnoreCase = variableNamesIgnoreCase;
    }

    @OrqueioQueryParam(value="variableValuesIgnoreCase", converter=BooleanConverter.class)
    public void setVariableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
        this.variableValuesIgnoreCase = variableValuesIgnoreCase;
    }

    @OrqueioQueryParam(value="caseInstanceVariables", converter=VariableListConverter.class)
    public void setCaseInstanceVariables(List<VariableQueryParameterDto> caseInstanceVariables) {
        this.caseInstanceVariables = caseInstanceVariables;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected CaseExecutionQuery createNewQuery(ProcessEngine engine) {
        return engine.getCaseService().createCaseExecutionQuery();
    }

    @Override
    protected void applyFilters(CaseExecutionQuery query) {
        Object variableValue;
        String op;
        String variableName;
        if (this.caseExecutionId != null) {
            query.caseExecutionId(this.caseExecutionId);
        }
        if (this.caseInstanceId != null) {
            query.caseInstanceId(this.caseInstanceId);
        }
        if (this.businessKey != null) {
            query.caseInstanceBusinessKey(this.businessKey);
        }
        if (this.caseDefinitionKey != null) {
            query.caseDefinitionKey(this.caseDefinitionKey);
        }
        if (this.caseDefinitionId != null) {
            query.caseDefinitionId(this.caseDefinitionId);
        }
        if (this.activityId != null) {
            query.activityId(this.activityId);
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
        if (this.required != null && this.required.booleanValue()) {
            query.required();
        }
        if (this.active != null && this.active.booleanValue()) {
            query.active();
        }
        if (this.enabled != null && this.enabled.booleanValue()) {
            query.enabled();
        }
        if (this.disabled != null && this.disabled.booleanValue()) {
            query.disabled();
        }
        if (Boolean.TRUE.equals(this.variableNamesIgnoreCase)) {
            query.matchVariableNamesIgnoreCase();
        }
        if (Boolean.TRUE.equals(this.variableValuesIgnoreCase)) {
            query.matchVariableValuesIgnoreCase();
        }
        if (this.variables != null) {
            for (VariableQueryParameterDto variableQueryParam : this.variables) {
                variableName = variableQueryParam.getName();
                op = variableQueryParam.getOperator();
                variableValue = variableQueryParam.resolveValue(this.objectMapper);
                if (op.equals("eq")) {
                    query.variableValueEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("gt")) {
                    query.variableValueGreaterThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("gteq")) {
                    query.variableValueGreaterThanOrEqual(variableName, variableValue);
                    continue;
                }
                if (op.equals("lt")) {
                    query.variableValueLessThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("lteq")) {
                    query.variableValueLessThanOrEqual(variableName, variableValue);
                    continue;
                }
                if (op.equals("neq")) {
                    query.variableValueNotEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("like")) {
                    query.variableValueLike(variableName, String.valueOf(variableValue));
                    continue;
                }
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Invalid variable comparator specified: " + op);
            }
        }
        if (this.caseInstanceVariables != null) {
            for (VariableQueryParameterDto variableQueryParam : this.caseInstanceVariables) {
                variableName = variableQueryParam.getName();
                op = variableQueryParam.getOperator();
                variableValue = variableQueryParam.resolveValue(this.objectMapper);
                if (op.equals("eq")) {
                    query.caseInstanceVariableValueEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("gt")) {
                    query.caseInstanceVariableValueGreaterThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("gteq")) {
                    query.caseInstanceVariableValueGreaterThanOrEqual(variableName, variableValue);
                    continue;
                }
                if (op.equals("lt")) {
                    query.caseInstanceVariableValueLessThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("lteq")) {
                    query.caseInstanceVariableValueLessThanOrEqual(variableName, variableValue);
                    continue;
                }
                if (op.equals("neq")) {
                    query.caseInstanceVariableValueNotEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("like")) {
                    query.caseInstanceVariableValueLike(variableName, String.valueOf(variableValue));
                    continue;
                }
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Invalid variable comparator specified: " + op);
            }
        }
    }

    @Override
    protected void applySortBy(CaseExecutionQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_EXECUTION_ID_VALUE)) {
            query.orderByCaseExecutionId();
        } else if (sortBy.equals(SORT_BY_DEFINITION_KEY_VALUE)) {
            query.orderByCaseDefinitionKey();
        } else if (sortBy.equals(SORT_BY_DEFINITION_ID_VALUE)) {
            query.orderByCaseDefinitionId();
        } else if (sortBy.equals(SORT_BY_TENANT_ID)) {
            query.orderByTenantId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_EXECUTION_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_DEFINITION_KEY_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_DEFINITION_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
    }
}

