/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.dto.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.orqueio.bpm.engine.ProcessEngine;
import io.orqueio.bpm.engine.rest.dto.AbstractQueryDto;
import io.orqueio.bpm.engine.rest.dto.OrqueioQueryParam;
import io.orqueio.bpm.engine.rest.dto.VariableQueryParameterDto;
import io.orqueio.bpm.engine.rest.dto.converter.BooleanConverter;
import io.orqueio.bpm.engine.rest.dto.converter.StringListConverter;
import io.orqueio.bpm.engine.rest.dto.converter.VariableListConverter;
import io.orqueio.bpm.engine.rest.exception.InvalidRequestException;
import io.orqueio.bpm.engine.runtime.CaseInstanceQuery;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CaseInstanceQueryDto
extends AbstractQueryDto<CaseInstanceQuery> {
    protected static final String SORT_BY_INSTANCE_ID_VALUE = "caseInstanceId";
    protected static final String SORT_BY_DEFINITION_KEY_VALUE = "caseDefinitionKey";
    protected static final String SORT_BY_DEFINITION_ID_VALUE = "caseDefinitionId";
    protected static final String SORT_BY_TENANT_ID = "tenantId";
    protected static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected String caseInstanceId;
    protected String businessKey;
    protected String caseDefinitionKey;
    protected String caseDefinitionId;
    protected String deploymentId;
    protected String superProcessInstance;
    protected String subProcessInstance;
    protected String superCaseInstance;
    protected String subCaseInstance;
    protected List<String> tenantIds;
    protected Boolean withoutTenantId;
    protected Boolean active;
    protected Boolean completed;
    protected Boolean terminated;
    protected List<VariableQueryParameterDto> variables;
    protected Boolean variableNamesIgnoreCase;
    protected Boolean variableValuesIgnoreCase;

    public CaseInstanceQueryDto() {
    }

    public CaseInstanceQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @OrqueioQueryParam(value="caseInstanceId")
    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @OrqueioQueryParam(value="businessKey")
    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    @OrqueioQueryParam(value="caseDefinitionKey")
    public void setCaseDefinitionKey(String caseDefinitionKey) {
        this.caseDefinitionKey = caseDefinitionKey;
    }

    @OrqueioQueryParam(value="caseDefinitionId")
    public void setCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    @OrqueioQueryParam(value="deploymentId")
    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    @OrqueioQueryParam(value="superProcessInstance")
    public void setSuperProcessInstance(String superProcessInstance) {
        this.superProcessInstance = superProcessInstance;
    }

    @OrqueioQueryParam(value="subProcessInstance")
    public void setSubProcessInstance(String subProcessInstance) {
        this.subProcessInstance = subProcessInstance;
    }

    @OrqueioQueryParam(value="superCaseInstance")
    public void setSuperCaseInstance(String superCaseInstance) {
        this.superCaseInstance = superCaseInstance;
    }

    @OrqueioQueryParam(value="subCaseInstance")
    public void setSubCaseInstance(String subCaseInstance) {
        this.subCaseInstance = subCaseInstance;
    }

    @OrqueioQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @OrqueioQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    @OrqueioQueryParam(value="active", converter=BooleanConverter.class)
    public void setActive(Boolean active) {
        this.active = active;
    }

    @OrqueioQueryParam(value="completed", converter=BooleanConverter.class)
    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    @OrqueioQueryParam(value="terminated", converter=BooleanConverter.class)
    public void setTerminated(Boolean terminated) {
        this.terminated = terminated;
    }

    @OrqueioQueryParam(value="variables", converter=VariableListConverter.class)
    public void setVariables(List<VariableQueryParameterDto> variables) {
        this.variables = variables;
    }

    @OrqueioQueryParam(value="variableNamesIgnoreCase", converter=BooleanConverter.class)
    public void setVariableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
        this.variableNamesIgnoreCase = variableNamesIgnoreCase;
    }

    @OrqueioQueryParam(value="variableValuesIgnoreCase", converter=BooleanConverter.class)
    public void setVariableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
        this.variableValuesIgnoreCase = variableValuesIgnoreCase;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected CaseInstanceQuery createNewQuery(ProcessEngine engine) {
        return engine.getCaseService().createCaseInstanceQuery();
    }

    @Override
    protected void applyFilters(CaseInstanceQuery query) {
        if (this.caseInstanceId != null) {
            query.caseInstanceId(this.caseInstanceId);
        }
        if (this.businessKey != null) {
            query.caseInstanceBusinessKey(this.businessKey);
        }
        if (this.caseDefinitionKey != null) {
            query.caseDefinitionKey(this.caseDefinitionKey);
        }
        if (this.caseDefinitionId != null) {
            query.caseDefinitionId(this.caseDefinitionId);
        }
        if (this.deploymentId != null) {
            query.deploymentId(this.deploymentId);
        }
        if (this.superProcessInstance != null) {
            query.superProcessInstanceId(this.superProcessInstance);
        }
        if (this.subProcessInstance != null) {
            query.subProcessInstanceId(this.subProcessInstance);
        }
        if (this.superCaseInstance != null) {
            query.superCaseInstanceId(this.superCaseInstance);
        }
        if (this.subCaseInstance != null) {
            query.subCaseInstanceId(this.subCaseInstance);
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
        if (this.active != null && this.active.booleanValue()) {
            query.active();
        }
        if (this.completed != null && this.completed.booleanValue()) {
            query.completed();
        }
        if (this.terminated != null && this.terminated.booleanValue()) {
            query.terminated();
        }
        if (Boolean.TRUE.equals(this.variableNamesIgnoreCase)) {
            query.matchVariableNamesIgnoreCase();
        }
        if (Boolean.TRUE.equals(this.variableValuesIgnoreCase)) {
            query.matchVariableValuesIgnoreCase();
        }
        if (this.variables != null) {
            for (VariableQueryParameterDto variableQueryParam : this.variables) {
                String variableName = variableQueryParam.getName();
                String op = variableQueryParam.getOperator();
                Object variableValue = variableQueryParam.resolveValue(this.objectMapper);
                if (op.equals("eq")) {
                    query.variableValueEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("gt")) {
                    query.variableValueGreaterThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("gteq")) {
                    query.variableValueGreaterThanOrEqual(variableName, variableValue);
                    continue;
                }
                if (op.equals("lt")) {
                    query.variableValueLessThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("lteq")) {
                    query.variableValueLessThanOrEqual(variableName, variableValue);
                    continue;
                }
                if (op.equals("neq")) {
                    query.variableValueNotEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("like")) {
                    query.variableValueLike(variableName, String.valueOf(variableValue));
                    continue;
                }
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Invalid variable comparator specified: " + op);
            }
        }
    }

    @Override
    protected void applySortBy(CaseInstanceQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_INSTANCE_ID_VALUE)) {
            query.orderByCaseInstanceId();
        } else if (sortBy.equals(SORT_BY_DEFINITION_KEY_VALUE)) {
            query.orderByCaseDefinitionKey();
        } else if (sortBy.equals(SORT_BY_DEFINITION_ID_VALUE)) {
            query.orderByCaseDefinitionId();
        } else if (sortBy.equals(SORT_BY_TENANT_ID)) {
            query.orderByTenantId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_INSTANCE_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_DEFINITION_KEY_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_DEFINITION_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
    }
}

