/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.exception;

import io.orqueio.bpm.engine.ProcessEnginePersistenceException;
import io.orqueio.bpm.engine.impl.util.ExceptionUtil;
import io.orqueio.bpm.engine.rest.exception.ExceptionHandlerHelper;
import io.orqueio.commons.logging.BaseLogger;
import jakarta.ws.rs.core.Response;
import java.sql.SQLException;

public class ExceptionLogger
extends BaseLogger {
    public static final String PROJECT_CODE = "ENGINE-REST";
    public static final String REST_API = "io.orqueio.bpm.engine.rest.exception";
    public static final ExceptionLogger REST_LOGGER = (ExceptionLogger)BaseLogger.createLogger(ExceptionLogger.class, (String)"ENGINE-REST", (String)"io.orqueio.bpm.engine.rest.exception", (String)"HTTP");

    public void log(Throwable throwable) {
        Response.Status status = ExceptionHandlerHelper.getInstance().getStatus(throwable);
        int statusCode = status.getStatusCode();
        if (statusCode < 500) {
            this.logDebug(String.valueOf(statusCode), ExceptionUtil.getExceptionStacktrace((Throwable)throwable), new Object[0]);
            return;
        }
        this.logInternalServerAndOtherStatusCodes(throwable, statusCode);
    }

    protected void logInternalServerAndOtherStatusCodes(Throwable throwable, int statusCode) {
        if (this.isPersistenceConnectionError(throwable)) {
            this.logError(String.valueOf(statusCode), ExceptionUtil.getExceptionStacktrace((Throwable)throwable), new Object[0]);
            return;
        }
        this.logWarn(String.valueOf(statusCode), ExceptionUtil.getExceptionStacktrace((Throwable)throwable), new Object[0]);
    }

    protected boolean isPersistenceConnectionError(Throwable throwable) {
        boolean isPersistenceException = throwable instanceof ProcessEnginePersistenceException;
        if (!isPersistenceException) {
            return false;
        }
        SQLException sqlException = this.getSqlException((ProcessEnginePersistenceException)throwable);
        if (sqlException == null) {
            return false;
        }
        String sqlState = sqlException.getSQLState();
        return sqlState != null && sqlState.startsWith("08");
    }

    protected SQLException getSqlException(ProcessEnginePersistenceException e) {
        boolean hasTwoCauses;
        boolean bl = hasTwoCauses = e.getCause() != null && e.getCause().getCause() != null;
        if (!hasTwoCauses) {
            return null;
        }
        Throwable cause = e.getCause().getCause();
        return cause instanceof SQLException ? (SQLException)cause : null;
    }
}

