/*
 * Decompiled with CFR 0.152.
 */
package io.orqueio.bpm.engine.rest.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;

public abstract class AbstractEmptyBodyFilter
implements Filter {
    protected static final Pattern CONTENT_TYPE_JSON_PATTERN = Pattern.compile("^application\\/json((;)(.*)?)?$", 2);

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        boolean isContentTypeJson = CONTENT_TYPE_JSON_PATTERN.matcher(req.getContentType() == null ? "" : req.getContentType()).find();
        if (isContentTypeJson) {
            PushbackInputStream requestBody = new PushbackInputStream((InputStream)req.getInputStream());
            int firstByte = requestBody.read();
            boolean isBodyEmpty = firstByte == -1;
            requestBody.unread(firstByte);
            chain.doFilter((ServletRequest)this.wrapRequest((HttpServletRequest)req, isBodyEmpty, requestBody), resp);
        } else {
            chain.doFilter(req, resp);
        }
    }

    public InputStream getRequestBody(boolean isBodyEmpty, PushbackInputStream requestBody) {
        return isBodyEmpty ? new ByteArrayInputStream("{}".getBytes(StandardCharsets.UTF_8)) : requestBody;
    }

    public abstract HttpServletRequestWrapper wrapRequest(HttpServletRequest var1, boolean var2, PushbackInputStream var3);

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public BufferedReader getReader(ServletInputStream inputStream) {
        return new BufferedReader(new InputStreamReader((InputStream)inputStream));
    }
}

